/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

@Minimize
@SupportedResourceType(value=ResourceType.CSS)
public class YUICssCompressorProcessor
implements ResourcePostProcessor,
ResourcePreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(YUICssCompressorProcessor.class);
    public static final String ALIAS = "yuiCssMin";
    private static final int linebreakpos = -1;

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        try {
            CssCompressor compressor = new CssCompressor(reader);
            compressor.compress(writer, -1);
        }
        catch (IOException e) {
            LOG.error("Exception occured while processing resource: " + resource + " using processor: " + ALIAS);
            this.onException(new WroRuntimeException("Exception during YuiCss processing of resource: " + resource, (Throwable)e));
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }
}

