/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.csslint.CssLint;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintError;
import ro.isdc.wro.extensions.processor.support.csslint.CssLintException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.Destroyable;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@SupportedResourceType(value=ResourceType.CSS)
public class CssLintProcessor
implements ResourcePreProcessor,
ResourcePostProcessor,
Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(CssLintProcessor.class);
    public static final String ALIAS = "cssLint";
    private String options;
    private ObjectPoolHelper<CssLint> enginePool = new ObjectPoolHelper<CssLint>(new ObjectFactory<CssLint>(){

        public CssLint create() {
            return CssLintProcessor.this.newCssLint();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        CssLint cssLint = this.enginePool.getObject();
        try {
            cssLint.setOptions(this.getOptions()).validate(content);
        }
        catch (CssLintException e) {
            this.onCssLintException(e, resource);
        }
        catch (WroRuntimeException e) {
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.error("Exception while applying cssLint processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
            this.onException(e);
        }
        finally {
            writer.write(content);
            reader.close();
            writer.close();
            this.enginePool.returnObject(cssLint);
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }

    protected CssLint newCssLint() {
        return new CssLint();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    protected void onCssLintException(CssLintException e, Resource resource) {
        String uri = resource == null ? "" : resource.getUri();
        LOG.error("The following resource: " + uri + " has " + e.getErrors().size() + " errors.");
        for (CssLintError x : e.getErrors()) {
            LOG.error(uri + " line " + x.getLine() + " column " + x.getCol() + ": " + x.getType() + " " + x.getMessage());
        }
    }

    public CssLintProcessor setOptionsAsString(String options) {
        this.options = options;
        return this;
    }

    private String getOptions() {
        if (this.options == null) {
            this.options = this.createDefaultOptions();
        }
        return this.options;
    }

    protected String createDefaultOptions() {
        return "";
    }

    public void destroy() throws Exception {
        this.enginePool.destroy();
    }
}

