/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.transactions;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class ChangeBasicTransactionAttributes
implements OnlineCommand,
OfflineCommand {
    private final Integer timeout;
    private final Boolean enableTtsmStatus;
    private final Boolean journalStoreEnableAsyncIO;
    private final Boolean jts;
    private final String nodeIdentifier;
    private final Boolean statisticsEnabled;
    private final Boolean useJournalStore;
    private final Boolean processIdUuid;
    private final String processIdSocketBinding;
    private final Integer processIdSocketMaxPorts;
    private final String socketBinding;
    private final String statusSocketBinding;
    private final Boolean recoveryListener;
    private final String objectStorePath;
    private final String objectStoreRelativeTo;

    private ChangeBasicTransactionAttributes(Builder builder) {
        this.timeout = builder.timeout;
        this.enableTtsmStatus = builder.enableTsmStatus;
        this.journalStoreEnableAsyncIO = builder.journalStoreEnableAsyncIO;
        this.jts = builder.jts;
        this.nodeIdentifier = builder.nodeIdentifier;
        this.statisticsEnabled = builder.statisticsEnabled;
        this.useJournalStore = builder.useJournalStore;
        this.processIdUuid = builder.processIdUuid;
        this.processIdSocketBinding = builder.processIdSocketBinding;
        this.processIdSocketMaxPorts = builder.processIdSocketMaxPorts;
        this.socketBinding = builder.socketBinding;
        this.statusSocketBinding = builder.statusSocketBinding;
        this.recoveryListener = builder.recoveryListener;
        this.objectStorePath = builder.objectStorePath;
        this.objectStoreRelativeTo = builder.objectStoreRelativeTo;
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        GroovyXmlTransform transform = GroovyXmlTransform.of(ChangeBasicTransactionAttributes.class).subtree("transactions", Subtree.subsystem("transactions")).parameter("nodeIdentifier", this.nodeIdentifier).parameter("timeout", this.timeout).parameter("enableTsmStatus", this.enableTtsmStatus).parameter("jts", this.jts).parameter("statisticsEnabled", this.statisticsEnabled).parameter("useJournalStore", this.useJournalStore).parameter("journalStoreEnableAsyncIO", this.journalStoreEnableAsyncIO).parameter("processIdUuid", this.processIdUuid).parameter("processIdSocketBinding", this.processIdSocketBinding).parameter("processIdSocketMaxPorts", this.processIdSocketMaxPorts).parameter("socketBinding", this.socketBinding).parameter("statusSocketBinding", this.statusSocketBinding).parameter("recoveryListener", this.recoveryListener).parameter("objectStorePath", this.objectStorePath).parameter("objectStoreRelativeTo", this.objectStoreRelativeTo).parameter("serverVersion", ctx.version).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address transatcionsAddress = Address.subsystem((String)"transactions");
        Batch batch = new Batch();
        if (this.nodeIdentifier != null) {
            batch.writeAttribute(transatcionsAddress, "node-identifier", this.nodeIdentifier);
        }
        if (this.enableTtsmStatus != null) {
            batch.writeAttribute(transatcionsAddress, "enable-tsm-status", this.enableTtsmStatus.booleanValue());
        }
        if (this.timeout != null) {
            batch.writeAttribute(transatcionsAddress, "default-timeout", this.timeout.intValue());
        }
        if (this.statisticsEnabled != null) {
            if (ctx.version.lessThan(ServerVersion.VERSION_2_0_0)) {
                batch.writeAttribute(transatcionsAddress, "enable-statistics", this.statisticsEnabled.booleanValue());
            } else {
                batch.writeAttribute(transatcionsAddress, "statistics-enabled", this.statisticsEnabled.booleanValue());
            }
        }
        if (this.jts != null) {
            batch.writeAttribute(transatcionsAddress, "jts", this.jts.booleanValue());
        }
        if (this.useJournalStore != null) {
            if (ctx.version.lessThan(ServerVersion.VERSION_4_0_0)) {
                batch.writeAttribute(transatcionsAddress, "use-hornetq-store", this.useJournalStore.booleanValue());
            } else {
                batch.writeAttribute(transatcionsAddress, "use-journal-store", this.useJournalStore.booleanValue());
            }
        }
        if (this.journalStoreEnableAsyncIO != null) {
            if (ctx.version.lessThan(ServerVersion.VERSION_4_0_0)) {
                batch.writeAttribute(transatcionsAddress, "hornetq-store-enable-async-io", this.journalStoreEnableAsyncIO.booleanValue());
            } else {
                batch.writeAttribute(transatcionsAddress, "journal-store-enable-async-io", this.journalStoreEnableAsyncIO.booleanValue());
            }
        }
        if (this.processIdUuid != null || this.processIdSocketBinding != null) {
            if (this.processIdUuid != null) {
                batch.writeAttribute(transatcionsAddress, "process-id-uuid", this.processIdUuid.booleanValue());
            } else {
                batch.undefineAttribute(transatcionsAddress, "process-id-uuid");
                if (this.processIdSocketBinding != null) {
                    batch.writeAttribute(transatcionsAddress, "process-id-socket-binding", this.processIdSocketBinding);
                }
                if (this.processIdSocketMaxPorts != null) {
                    batch.writeAttribute(transatcionsAddress, "process-id-socket-max-ports", this.processIdSocketMaxPorts.intValue());
                }
            }
        }
        if (this.socketBinding != null) {
            batch.writeAttribute(transatcionsAddress, "socket-binding", this.socketBinding);
        }
        if (this.statusSocketBinding != null) {
            batch.writeAttribute(transatcionsAddress, "status-socket-binding", this.statusSocketBinding);
        }
        if (this.recoveryListener != null) {
            batch.writeAttribute(transatcionsAddress, "recovery-listener", this.recoveryListener.booleanValue());
        }
        if (this.objectStorePath != null) {
            batch.writeAttribute(transatcionsAddress, "object-store-path", this.objectStorePath);
        }
        if (this.objectStoreRelativeTo != null) {
            batch.writeAttribute(transatcionsAddress, "object-store-relative-to", this.objectStoreRelativeTo);
        }
        ops.batch(batch);
    }

    public static final class Builder {
        private Integer timeout;
        private Boolean enableTsmStatus;
        private Boolean journalStoreEnableAsyncIO;
        private Boolean jts;
        private String nodeIdentifier;
        private Boolean statisticsEnabled;
        private Boolean useJournalStore;
        private Boolean processIdUuid;
        private String processIdSocketBinding;
        private Integer processIdSocketMaxPorts;
        private String socketBinding;
        private String statusSocketBinding;
        private Boolean recoveryListener;
        private String objectStorePath;
        private String objectStoreRelativeTo;

        public Builder timeout(int val) {
            this.timeout = val;
            return this;
        }

        public Builder enableTsmStatus(boolean val) {
            this.enableTsmStatus = val;
            return this;
        }

        public Builder journalStoreEnableAsyncIO(boolean val) {
            this.journalStoreEnableAsyncIO = val;
            return this;
        }

        public Builder jts(boolean val) {
            this.jts = val;
            return this;
        }

        public Builder nodeIdentifier(String val) {
            if (val == null) {
                throw new IllegalArgumentException("Node identifier can not be null!");
            }
            this.nodeIdentifier = val;
            return this;
        }

        public Builder statisticsEnabled(boolean val) {
            this.statisticsEnabled = val;
            return this;
        }

        public Builder useJournalStore(boolean val) {
            this.useJournalStore = val;
            return this;
        }

        public Builder processIdUuid(Boolean val) {
            this.processIdUuid = val;
            return this;
        }

        public Builder processIdSocketBinding(String val) {
            this.processIdSocketBinding = val;
            return this;
        }

        public Builder processIdSocketMaxPorts(Integer val) {
            this.processIdSocketMaxPorts = val;
            return this;
        }

        public Builder socketBinding(String val) {
            this.socketBinding = val;
            return this;
        }

        public Builder statusSocketBinding(String val) {
            this.statusSocketBinding = val;
            return this;
        }

        public Builder recoveryListener(Boolean val) {
            this.recoveryListener = val;
            return this;
        }

        public Builder objectStorePath(String val) {
            this.objectStorePath = val;
            return this;
        }

        public Builder objectStoreRelativeTo(String val) {
            this.objectStoreRelativeTo = val;
            return this;
        }

        public ChangeBasicTransactionAttributes build() {
            return new ChangeBasicTransactionAttributes(this);
        }
    }
}

