/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.patching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.ReadAttributeOption;
import org.wildfly.extras.creaper.core.online.operations.ReadResourceOption;

public final class PatchingOperations {
    private final OnlineManagementClient client;
    private final Operations ops;
    private final Address patchingAddress;

    public PatchingOperations(OnlineManagementClient client) {
        this.client = client;
        this.ops = new Operations(client);
        this.patchingAddress = Address.coreService((String)"patching");
    }

    public List<PatchHistoryEntry> getHistory() throws IOException {
        this.checkServerVersionIsSupported();
        List asList = this.ops.invoke("show-history", this.patchingAddress).listValue();
        ArrayList<PatchHistoryEntry> entries = new ArrayList<PatchHistoryEntry>(asList.size());
        for (ModelNode modelNode : asList) {
            PatchHistoryEntry phe = new PatchHistoryEntry();
            phe.setPatchId(modelNode.get("patch-id").asString());
            phe.setType(modelNode.get("type").asString());
            phe.setAppliedAt(modelNode.get("applied-at").asString());
            entries.add(phe);
        }
        return entries;
    }

    public PatchHistoryEntry getHistoryEntry(String patchId) throws IOException {
        List<PatchHistoryEntry> patchingHistory = this.getHistory();
        PatchHistoryEntry foundPatchEntry = null;
        for (PatchHistoryEntry entry : patchingHistory) {
            if (!entry.getPatchId().equals(patchId)) continue;
            foundPatchEntry = entry;
            break;
        }
        return foundPatchEntry;
    }

    public PatchInfo getPatchInfo() throws IOException {
        this.checkServerVersionIsSupported();
        ModelNodeResult modelNodeResult = this.ops.readResource(this.patchingAddress, new ReadResourceOption[]{ReadResourceOption.RECURSIVE, ReadResourceOption.INCLUDE_RUNTIME});
        modelNodeResult.assertDefinedValue();
        ModelNode result = modelNodeResult.value();
        PatchInfo patchInfo = new PatchInfo();
        patchInfo.setCumulativePatchId(result.get("cumulative-patch-id").asString());
        patchInfo.setVersion(result.get("version").asString());
        for (ModelNode patch : result.get("patches").asList()) {
            patchInfo.getPatches().add(patch.asString());
        }
        return patchInfo;
    }

    public String getCumulativePatchId() throws IOException {
        this.checkServerVersionIsSupported();
        return this.ops.readAttribute(this.patchingAddress, "cumulative-patch-id", new ReadAttributeOption[0]).stringValue(null);
    }

    public String getCurrentServerVersion() throws IOException {
        this.checkServerVersionIsSupported();
        return this.ops.readAttribute(this.patchingAddress, "version", new ReadAttributeOption[0]).stringValue(null);
    }

    public List<String> getPatchesIds() throws IOException {
        this.checkServerVersionIsSupported();
        return this.ops.readAttribute(this.patchingAddress, "patches", new ReadAttributeOption[0]).stringListValue(Collections.emptyList());
    }

    public boolean isAnyPatchInstalled() throws IOException {
        return !this.getHistory().isEmpty();
    }

    public boolean isPatchInstalled(String patchId) throws IOException {
        if (patchId == null) {
            throw new IllegalArgumentException("patchId is null");
        }
        if (patchId.equals(this.getCumulativePatchId())) {
            return true;
        }
        for (String id : this.getPatchesIds()) {
            if (!patchId.equals(id)) continue;
            return true;
        }
        PatchHistoryEntry phe = new PatchHistoryEntry(patchId);
        return this.getHistory().contains(phe);
    }

    private void checkServerVersionIsSupported() {
        try {
            if (this.client.version().greaterThan(ServerVersion.VERSION_21_0_0)) {
                throw new AssertionError((Object)"Patching subsystem has been removed in WildFly 29.");
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public static final class PatchHistoryEntry {
        private String patchId;
        private String type;
        private String appliedAt;

        public PatchHistoryEntry(String patchId, String type, String appliedAt) {
            this.patchId = patchId;
            this.type = type;
            this.appliedAt = appliedAt;
        }

        public PatchHistoryEntry(String patchId) {
            this.patchId = patchId;
        }

        public PatchHistoryEntry() {
        }

        public String getPatchId() {
            return this.patchId;
        }

        public void setPatchId(String patchId) {
            this.patchId = patchId;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAppliedAt() {
            return this.appliedAt;
        }

        public void setAppliedAt(String appliedAt) {
            this.appliedAt = appliedAt;
        }

        public boolean equals(Object other) {
            if (other != null && other instanceof PatchHistoryEntry) {
                PatchHistoryEntry that = (PatchHistoryEntry)other;
                return this.patchId.equals(that.patchId);
            }
            return false;
        }

        public int hashCode() {
            return this.patchId.hashCode();
        }

        public String toString() {
            return "PatchHistoryEntry {patchId='" + this.patchId + "', type='" + this.type + "', appliedAt='" + this.appliedAt + "'}";
        }
    }

    public static final class PatchInfo {
        private String version;
        private String cumulativePatchId;
        private List<String> patches = new ArrayList<String>();

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getCumulativePatchId() {
            return this.cumulativePatchId;
        }

        public void setCumulativePatchId(String cumulativePatchId) {
            this.cumulativePatchId = cumulativePatchId;
        }

        public List<String> getPatches() {
            return this.patches;
        }

        public void setPatches(List<String> patches) {
            this.patches = patches;
        }

        public String toString() {
            return "PatchInfo{version='" + this.version + '\'' + ", cumulativePatchId='" + this.cumulativePatchId + '\'' + ", patches=" + this.patches + '}';
        }
    }
}

