/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.logging;

import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.commands.logging.AbstractLoggerCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Batch;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public final class ChangeLogger
extends AbstractLoggerCommand {
    private ChangeLogger(Builder builder) {
        super(builder);
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        Operations ops = new Operations(ctx.client);
        Address loggerAddress = Address.subsystem((String)"logging").and("logger", this.category);
        if (!ops.exists(loggerAddress)) {
            throw new IllegalStateException("Log category %s does not exist: " + this.category);
        }
        Batch batch = new Batch();
        if (this.filter != null) {
            batch.writeAttribute(loggerAddress, "filter-spec", this.filter);
        }
        if (this.level != null) {
            batch.writeAttribute(loggerAddress, "level", this.level.value());
        }
        if (this.useParentHandler != null) {
            batch.writeAttribute(loggerAddress, "use-parent-handlers", this.useParentHandler.booleanValue());
        }
        if (this.level != null) {
            batch.writeAttribute(loggerAddress, "level", this.level.value());
        }
        if (this.handlers != null) {
            if (this.handlers.isEmpty()) {
                batch.undefineAttribute(loggerAddress, "handlers");
            } else {
                batch.writeListAttribute(loggerAddress, "handlers", this.handlers.toArray(new String[this.handlers.size()]));
            }
        }
        ops.batch(batch);
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        GroovyXmlTransform transform = GroovyXmlTransform.of(ChangeLogger.class).subtree("logging", Subtree.subsystem("logging")).parameter("category", this.category).parameter("handlers", this.handlers).parameter("filter", this.filter).parameter("level", this.level == null ? null : this.level.value()).parameter("useParentHandler", this.useParentHandler == null ? null : String.valueOf(this.useParentHandler)).build();
        ctx.client.apply(new OfflineCommand[]{transform});
    }

    public String toString() {
        return "ChangeLogger " + this.category;
    }

    public static final class Builder
    extends AbstractLoggerCommand.Builder<Builder> {
        public Builder(String category) {
            super(category);
        }

        @Override
        public ChangeLogger build() {
            return new ChangeLogger(this);
        }
    }
}

