/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.elytron.tls;

import org.wildfly.extras.creaper.commands.elytron.tls.AbstractAddSSLContext;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.GroovyXmlTransform;
import org.wildfly.extras.creaper.commands.foundation.offline.xml.Subtree;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.offline.OfflineCommand;
import org.wildfly.extras.creaper.core.offline.OfflineCommandContext;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddClientSSLContext
extends AbstractAddSSLContext {
    private AddClientSSLContext(Builder builder) {
        super(builder);
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new AssertionError((Object)"Elytron is available since WildFly 11.");
        }
        if (this.cipherSuiteNames != null && ctx.version.lessThan(ServerVersion.VERSION_12_0_0)) {
            throw new AssertionError((Object)"cipher-suite-names attribute is available since WildFly 19");
        }
        Operations ops = new Operations(ctx.client);
        Address clientSSLContextAddress = Address.subsystem((String)"elytron").and("client-ssl-context", this.name);
        if (this.replaceExisting) {
            ops.removeIfExists(clientSSLContextAddress);
            new Administration(ctx.client).reloadIfRequired();
        }
        ops.add(clientSSLContextAddress, Values.empty().andOptional("cipher-suite-filter", this.cipherSuiteFilter).andOptional("cipher-suite-names", this.cipherSuiteNames).andOptional("key-manager", this.keyManager).andOptional("trust-manager", this.trustManager).andListOptional(String.class, "protocols", this.protocols));
    }

    public void apply(OfflineCommandContext ctx) throws Exception {
        if (ctx.version.lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new AssertionError((Object)"Elytron is available since WildFly 11.");
        }
        if (this.cipherSuiteNames != null && ctx.version.lessThan(ServerVersion.VERSION_12_0_0)) {
            throw new AssertionError((Object)"cipher-suite-names attribute is available since WildFly 19");
        }
        ctx.client.apply(new OfflineCommand[]{GroovyXmlTransform.of(AddClientSSLContext.class).subtree("elytronSubsystem", Subtree.subsystem("elytron")).parameter("atrName", this.name).parameter("atrCipherSuiteFilter", this.cipherSuiteFilter).parameter("atrCipherSuiteNames", this.cipherSuiteNames).parameter("atrKeyManager", this.keyManager).parameter("atrTrustManager", this.trustManager).parameter("atrProtocols", this.protocols != null ? this.joinList(this.protocols) : null).parameter("atrProviders", this.providers).parameter("atrProviderName", this.providerName).parameter("atrReplaceExisting", this.replaceExisting).build()});
    }

    public static final class Builder
    extends AbstractAddSSLContext.Builder<Builder> {
        public Builder(String name) {
            super(name);
        }

        @Override
        public AddClientSSLContext build() {
            return new AddClientSSLContext(this);
        }
    }
}

