/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.creaper.commands.elytron.authenticationclient;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.wildfly.extras.creaper.core.ServerVersion;
import org.wildfly.extras.creaper.core.online.OnlineCommand;
import org.wildfly.extras.creaper.core.online.OnlineCommandContext;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;
import org.wildfly.extras.creaper.core.online.operations.Values;
import org.wildfly.extras.creaper.core.online.operations.admin.Administration;

public final class AddAuthenticationContext
implements OnlineCommand {
    private final String name;
    private final String extend;
    private final boolean replaceExisting;
    private final List<MatchRule> matchRules;

    private AddAuthenticationContext(Builder builder) {
        this.name = builder.name;
        this.extend = builder.extend;
        this.replaceExisting = builder.replaceExisting;
        this.matchRules = builder.matchRules;
    }

    public void apply(OnlineCommandContext ctx) throws Exception {
        if (ctx.version.lessThan(ServerVersion.VERSION_5_0_0)) {
            throw new AssertionError((Object)"Elytron is available since WildFly 11.");
        }
        Operations ops = new Operations(ctx.client);
        Address realmAddress = Address.subsystem((String)"elytron").and("authentication-context", this.name);
        if (this.replaceExisting) {
            ops.removeIfExists(realmAddress);
            new Administration(ctx.client).reloadIfRequired();
        }
        ArrayList<ModelNode> matchRulesNodeList = null;
        if (this.matchRules != null && !this.matchRules.isEmpty()) {
            matchRulesNodeList = new ArrayList<ModelNode>();
            for (MatchRule matchRule : this.matchRules) {
                ModelNode matchRuleNode = new ModelNode();
                this.addOptional(matchRuleNode, "match-abstract-type", matchRule.matchAbstractType);
                this.addOptional(matchRuleNode, "match-abstract-type-authority", matchRule.matchAbstractTypeAuthority);
                this.addOptional(matchRuleNode, "match-host", matchRule.matchHost);
                this.addOptional(matchRuleNode, "match-local-security-domain", matchRule.matchLocalSecurityDomain);
                this.addOptional(matchRuleNode, "match-no-user", matchRule.matchNoUser);
                this.addOptional(matchRuleNode, "match-path", matchRule.matchPath);
                this.addOptional(matchRuleNode, "match-port", matchRule.matchPort);
                this.addOptional(matchRuleNode, "match-protocol", matchRule.matchProtocol);
                this.addOptional(matchRuleNode, "match-urn", matchRule.matchUrn);
                this.addOptional(matchRuleNode, "match-user", matchRule.matchUser);
                this.addOptional(matchRuleNode, "authentication-configuration", matchRule.authenticationConfiguration);
                this.addOptional(matchRuleNode, "ssl-context", matchRule.sslContext);
                matchRulesNodeList.add(matchRuleNode.asObject());
            }
        }
        ops.add(realmAddress, Values.empty().andOptional("extends", this.extend).andListOptional(ModelNode.class, "match-rules", matchRulesNodeList));
    }

    private void addOptional(ModelNode node, String name, String value) {
        if (value != null && !value.isEmpty()) {
            node.add(name, value);
        }
    }

    private void addOptional(ModelNode node, String name, Boolean value) {
        if (value != null) {
            node.add(name, value.booleanValue());
        }
    }

    private void addOptional(ModelNode node, String name, Integer value) {
        if (value != null) {
            node.add(name, value.intValue());
        }
    }

    public static final class MatchRuleBuilder {
        private String matchAbstractType;
        private String matchAbstractTypeAuthority;
        private String matchHost;
        private String matchLocalSecurityDomain;
        private Boolean matchNoUser;
        private String matchPath;
        private Integer matchPort;
        private String matchProtocol;
        private String matchUrn;
        private String matchUser;
        private String authenticationConfiguration;
        private String sslContext;

        public MatchRuleBuilder matchAbstractType(String matchAbstractType) {
            this.matchAbstractType = matchAbstractType;
            return this;
        }

        public MatchRuleBuilder matchAbstractTypeAuthority(String matchAbstractTypeAuthority) {
            this.matchAbstractTypeAuthority = matchAbstractTypeAuthority;
            return this;
        }

        public MatchRuleBuilder matchHost(String matchHost) {
            this.matchHost = matchHost;
            return this;
        }

        public MatchRuleBuilder matchLocalSecurityDomain(String matchLocalSecurityDomain) {
            this.matchLocalSecurityDomain = matchLocalSecurityDomain;
            return this;
        }

        public MatchRuleBuilder matchNoUser(Boolean matchNoUser) {
            this.matchNoUser = matchNoUser;
            return this;
        }

        public MatchRuleBuilder matchPath(String matchPath) {
            this.matchPath = matchPath;
            return this;
        }

        public MatchRuleBuilder matchPort(Integer matchPort) {
            this.matchPort = matchPort;
            return this;
        }

        public MatchRuleBuilder matchProtocol(String matchProtocol) {
            this.matchProtocol = matchProtocol;
            return this;
        }

        public MatchRuleBuilder matchUrn(String matchUrn) {
            this.matchUrn = matchUrn;
            return this;
        }

        public MatchRuleBuilder matchUser(String matchUser) {
            this.matchUser = matchUser;
            return this;
        }

        public MatchRuleBuilder authenticationConfiguration(String authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public MatchRuleBuilder sslContext(String sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public MatchRule build() {
            return new MatchRule(this);
        }
    }

    public static final class MatchRule {
        private final String matchAbstractType;
        private final String matchAbstractTypeAuthority;
        private final String matchHost;
        private final String matchLocalSecurityDomain;
        private final Boolean matchNoUser;
        private final String matchPath;
        private final Integer matchPort;
        private final String matchProtocol;
        private final String matchUrn;
        private final String matchUser;
        private final String authenticationConfiguration;
        private final String sslContext;

        private MatchRule(MatchRuleBuilder builder) {
            this.matchAbstractType = builder.matchAbstractType;
            this.matchAbstractTypeAuthority = builder.matchAbstractTypeAuthority;
            this.matchHost = builder.matchHost;
            this.matchLocalSecurityDomain = builder.matchLocalSecurityDomain;
            this.matchNoUser = builder.matchNoUser;
            this.matchPath = builder.matchPath;
            this.matchPort = builder.matchPort;
            this.matchProtocol = builder.matchProtocol;
            this.matchUrn = builder.matchUrn;
            this.matchUser = builder.matchUser;
            this.authenticationConfiguration = builder.authenticationConfiguration;
            this.sslContext = builder.sslContext;
        }

        public String getMatchAbstractType() {
            return this.matchAbstractType;
        }

        public String getMatchAbstractTypeAuthority() {
            return this.matchAbstractTypeAuthority;
        }

        public String getMatchHost() {
            return this.matchHost;
        }

        public String getMatchLocalSecurityDomain() {
            return this.matchLocalSecurityDomain;
        }

        public Boolean getMatchNoUser() {
            return this.matchNoUser;
        }

        public String getMatchPath() {
            return this.matchPath;
        }

        public Integer getMatchPort() {
            return this.matchPort;
        }

        public String getMatchProtocol() {
            return this.matchProtocol;
        }

        public String getMatchUrn() {
            return this.matchUrn;
        }

        public String getMatchUser() {
            return this.matchUser;
        }

        public String getAuthenticationConfiguration() {
            return this.authenticationConfiguration;
        }

        public String getSslContext() {
            return this.sslContext;
        }
    }

    public static final class Builder {
        private final String name;
        private String extend;
        private boolean replaceExisting;
        private List<MatchRule> matchRules = new ArrayList<MatchRule>();

        public Builder(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name of the authentication-context must be specified as non null value");
            }
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Name of the authentication-context must not be empty value");
            }
            this.name = name;
        }

        public Builder extend(String extend) {
            this.extend = extend;
            return this;
        }

        public Builder addMatchRules(MatchRule ... matchRule) {
            if (matchRule == null) {
                throw new IllegalArgumentException("MatchRule added to authentication-context must not be null");
            }
            Collections.addAll(this.matchRules, matchRule);
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public AddAuthenticationContext build() {
            return new AddAuthenticationContext(this);
        }
    }
}

