/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.test.support.matcher;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.test.support.AssertionErrors;
import org.springframework.ws.test.support.matcher.AbstractSoapMessageMatcher;
import org.springframework.xml.transform.TransformerHelper;
import org.w3c.dom.Document;

public class SoapEnvelopeDiffMatcher
extends AbstractSoapMessageMatcher {
    private final Source expected;
    private final TransformerHelper transformerHelper = new TransformerHelper();

    public SoapEnvelopeDiffMatcher(Source expected) {
        Assert.notNull((Object)expected, (String)"'expected' must not be null");
        this.expected = expected;
    }

    @Override
    protected void match(SoapMessage soapMessage) throws IOException, AssertionError {
        Document actualDocument = soapMessage.getDocument();
        Document expectedDocument = this.createDocumentFromSource(this.expected);
        Diff diff = new Diff(expectedDocument, actualDocument);
        AssertionErrors.assertTrue("Envelopes are different, " + diff.toString(), diff.similar());
    }

    private Document createDocumentFromSource(Source source) {
        try {
            DOMResult result = new DOMResult();
            this.transformerHelper.transform(source, (Result)result);
            return (Document)result.getNode();
        }
        catch (TransformerException ex) {
            AssertionErrors.fail("Could not transform source to DOMResult" + ex.getMessage());
            return null;
        }
    }

    static {
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }
}

