/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import org.springframework.binding.convert.converters.Converter;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.Assert;

public class SpringConvertingConverterAdapter
implements Converter {
    private final Class sourceClass;
    private final Class targetClass;
    private ConversionService conversionService;

    public SpringConvertingConverterAdapter(Class sourceClass, Class targetClass, ConversionService conversionService) {
        Assert.notNull((Object)sourceClass, (String)"The source class to convert from is required.");
        Assert.notNull((Object)targetClass, (String)"The target class to convert to is required.");
        Assert.notNull((Object)conversionService, (String)"A Spring ConversionService is required.");
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.conversionService = conversionService;
    }

    public Object convertSourceToTargetClass(Object source, Class targetClass) throws Exception {
        return this.conversionService.convert(source, targetClass);
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }
}

