/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.server;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.server.PathContainer;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

class PathResourceLookupFunction
implements Function<ServerRequest, Mono<Resource>> {
    private final PathPattern pattern;
    private final Resource location;

    public PathResourceLookupFunction(String pattern, Resource location) {
        Assert.hasLength((String)pattern, (String)"'pattern' must not be empty");
        Assert.notNull((Object)location, (String)"'location' must not be null");
        this.pattern = PathPatternParser.defaultInstance.parse(pattern);
        this.location = location;
    }

    @Override
    public Mono<Resource> apply(ServerRequest request) {
        PathContainer pathContainer = request.requestPath().pathWithinApplication();
        if (!this.pattern.matches(pathContainer)) {
            return Mono.empty();
        }
        String path = this.processPath((pathContainer = this.pattern.extractPathWithinPattern(pathContainer)).value());
        if (!StringUtils.hasText((String)path) || this.isInvalidPath(path)) {
            return Mono.empty();
        }
        if (this.isInvalidEncodedInputPath(path)) {
            return Mono.empty();
        }
        if (!(this.location instanceof UrlResource)) {
            path = UriUtils.decode((String)path, (Charset)StandardCharsets.UTF_8);
        }
        try {
            Resource resource2 = this.location.createRelative(path);
            if (resource2.isReadable() && this.isResourceUnderLocation(resource2)) {
                return Mono.just((Object)resource2);
            }
            return Mono.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    protected String processPath(String path) {
        path = StringUtils.replace((String)path, (String)"\\", (String)"/");
        path = this.cleanDuplicateSlashes(path);
        return this.cleanLeadingSlash(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanDuplicateSlashes(String path) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i2 = 0; i2 < path.length(); ++i2) {
            char curr = path.charAt(i2);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path.substring(0, i2));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path.charAt(i2));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path;
    }

    private String cleanLeadingSlash(String path) {
        boolean slash = false;
        for (int i2 = 0; i2 < path.length(); ++i2) {
            if (path.charAt(i2) == '/') {
                slash = true;
                continue;
            }
            if (path.charAt(i2) <= ' ' || path.charAt(i2) == '\u007f') continue;
            if (i2 == 0 || i2 == 1 && slash) {
                return path;
            }
            return slash ? "/" + path.substring(i2) : path.substring(i2);
        }
        return slash ? "/" : "";
    }

    private boolean isInvalidPath(String path) {
        if (path.contains("WEB-INF") || path.contains("META-INF")) {
            return true;
        }
        if (path.contains(":/")) {
            String relativePath;
            String string = relativePath = path.charAt(0) == '/' ? path.substring(1) : path;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                return true;
            }
        }
        return path.contains("..") && StringUtils.cleanPath((String)path).contains("../");
    }

    private boolean isInvalidEncodedInputPath(String path) {
        if (path.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(path, StandardCharsets.UTF_8);
                if (this.isInvalidPath(decodedPath)) {
                    return true;
                }
                if (this.isInvalidPath(decodedPath = this.processPath(decodedPath))) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isResourceUnderLocation(Resource resource2) throws IOException {
        String locationPath;
        String resourcePath;
        if (resource2.getClass() != this.location.getClass()) {
            return false;
        }
        if (resource2 instanceof UrlResource) {
            resourcePath = resource2.getURL().toExternalForm();
            locationPath = StringUtils.cleanPath((String)this.location.getURL().toString());
        } else if (resource2 instanceof ClassPathResource) {
            ClassPathResource classPathResource = (ClassPathResource)resource2;
            resourcePath = classPathResource.getPath();
            locationPath = StringUtils.cleanPath((String)((ClassPathResource)this.location).getPath());
        } else {
            resourcePath = resource2.getURL().getPath();
            locationPath = StringUtils.cleanPath((String)this.location.getURL().getPath());
        }
        if (locationPath.equals(resourcePath)) {
            return true;
        }
        locationPath = locationPath.endsWith("/") || locationPath.isEmpty() ? locationPath : locationPath + "/";
        return resourcePath.startsWith(locationPath) && !this.isInvalidEncodedInputPath(resourcePath);
    }

    private boolean isInvalidEncodedResourcePath(String resourcePath) {
        if (resourcePath.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(resourcePath, StandardCharsets.UTF_8);
                if (decodedPath.contains("../") || decodedPath.contains("..\\")) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        return this.pattern + " -> " + this.location;
    }
}

