/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.bean.override.mockito;

import org.mockito.plugins.MockResolver;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SpringMockResolver
implements MockResolver {
    static final boolean SPRING_AOP_PRESENT = ClassUtils.isPresent((String)"org.springframework.aop.framework.Advised", (ClassLoader)SpringMockResolver.class.getClassLoader());

    public Object resolve(Object instance) {
        if (SPRING_AOP_PRESENT) {
            return SpringMockResolver.getUltimateTargetObject(instance);
        }
        return instance;
    }

    static Object getUltimateTargetObject(Object candidate) {
        Assert.notNull((Object)candidate, (String)"Candidate must not be null");
        try {
            Object target;
            Advised advised;
            TargetSource targetSource;
            if (AopUtils.isAopProxy((Object)candidate) && candidate instanceof Advised && (targetSource = (advised = (Advised)candidate).getTargetSource()).isStatic() && (target = targetSource.getTarget()) != null) {
                return SpringMockResolver.getUltimateTargetObject(target);
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to unwrap proxied object", ex);
        }
        return candidate;
    }

    static void rejectUnsupportedSpyTarget(String beanName, Object bean) throws IllegalStateException {
        Advised advised;
        if (SPRING_AOP_PRESENT && AopUtils.isAopProxy((Object)bean) && bean instanceof Advised && !(advised = (Advised)bean).getTargetSource().isStatic()) {
            throw new IllegalStateException("@MockitoSpyBean cannot be applied to bean '%s', because it is a Spring AOP proxy with a non-static TargetSource. Perhaps you have attempted to spy on a scoped proxy, which is not supported.".formatted(beanName));
        }
    }
}

