/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.function.Function;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2ClientConfigurerUtils;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutAuthenticationProvider;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutFilter;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcBackChannelLogoutHandler;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OidcLogoutAuthenticationConverter;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.oidc.session.OidcSessionRegistry;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.logout.CompositeLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.util.Assert;

public final class OidcLogoutConfigurer<B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<OidcLogoutConfigurer<B>, B> {
    private BackChannelLogoutConfigurer backChannel;

    public OidcLogoutConfigurer<B> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    public OidcLogoutConfigurer<B> oidcSessionRegistry(OidcSessionRegistry oidcSessionRegistry) {
        Assert.notNull((Object)oidcSessionRegistry, (String)"oidcSessionRegistry cannot be null");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(OidcSessionRegistry.class, oidcSessionRegistry);
        return this;
    }

    public OidcLogoutConfigurer<B> backChannel(Customizer<BackChannelLogoutConfigurer> backChannelLogoutConfigurer) {
        if (this.backChannel == null) {
            this.backChannel = new BackChannelLogoutConfigurer();
        }
        backChannelLogoutConfigurer.customize(this.backChannel);
        return this;
    }

    @Override
    @Deprecated(forRemoval=true, since="6.2")
    public B and() {
        return (B)((HttpSecurityBuilder)this.getBuilder());
    }

    @Override
    public void configure(B builder) throws Exception {
        if (this.backChannel != null) {
            this.backChannel.configure(builder);
        }
    }

    public final class BackChannelLogoutConfigurer {
        private AuthenticationConverter authenticationConverter;
        private final AuthenticationManager authenticationManager = new ProviderManager(new AuthenticationProvider[]{new OidcBackChannelLogoutAuthenticationProvider()});
        private Function<B, LogoutHandler> logoutHandler = this::logoutHandler;

        private AuthenticationConverter authenticationConverter(B http) {
            if (this.authenticationConverter == null) {
                ClientRegistrationRepository clientRegistrationRepository = OAuth2ClientConfigurerUtils.getClientRegistrationRepository(http);
                this.authenticationConverter = new OidcLogoutAuthenticationConverter(clientRegistrationRepository);
            }
            return this.authenticationConverter;
        }

        private AuthenticationManager authenticationManager() {
            return this.authenticationManager;
        }

        private LogoutHandler logoutHandler(B http) {
            OidcBackChannelLogoutHandler logoutHandler = (OidcBackChannelLogoutHandler)this.getBeanOrNull(OidcBackChannelLogoutHandler.class);
            if (logoutHandler != null) {
                return logoutHandler;
            }
            logoutHandler = new OidcBackChannelLogoutHandler(OAuth2ClientConfigurerUtils.getOidcSessionRegistry(http));
            return logoutHandler;
        }

        public BackChannelLogoutConfigurer logoutUri(String logoutUri) {
            this.logoutHandler = http -> {
                OidcBackChannelLogoutHandler logoutHandler = new OidcBackChannelLogoutHandler(OAuth2ClientConfigurerUtils.getOidcSessionRegistry(http));
                logoutHandler.setLogoutUri(logoutUri);
                return logoutHandler;
            };
            return this;
        }

        public BackChannelLogoutConfigurer logoutHandler(LogoutHandler logoutHandler) {
            this.logoutHandler = http -> logoutHandler;
            return this;
        }

        void configure(B http) {
            LogoutHandler oidcLogout = this.logoutHandler.apply(http);
            SecurityContextLogoutHandler sessionLogout = new SecurityContextLogoutHandler();
            LogoutConfigurer logout = http.getConfigurer(LogoutConfigurer.class);
            if (logout != null) {
                sessionLogout = new CompositeLogoutHandler(logout.getLogoutHandlers());
            }
            OidcBackChannelLogoutFilter filter = new OidcBackChannelLogoutFilter(this.authenticationConverter(http), this.authenticationManager(), new EitherLogoutHandler(oidcLogout, (LogoutHandler)sessionLogout));
            http.addFilterBefore((Filter)filter, CsrfFilter.class);
        }

        private <T> T getBeanOrNull(Class<?> clazz) {
            ApplicationContext context = ((HttpSecurityBuilder)OidcLogoutConfigurer.this.getBuilder()).getSharedObject(ApplicationContext.class);
            if (context == null) {
                return null;
            }
            return (T)context.getBeanProvider(clazz).getIfUnique();
        }

        private static final class EitherLogoutHandler
        implements LogoutHandler {
            private final LogoutHandler left;
            private final LogoutHandler right;

            EitherLogoutHandler(LogoutHandler left, LogoutHandler right) {
                this.left = left;
                this.right = right;
            }

            public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
                if (request.getParameter("_spring_security_internal_logout") == null) {
                    this.left.logout(request, response, authentication);
                } else {
                    this.right.logout(request, response, authentication);
                }
            }
        }
    }
}

