/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurer;

public abstract class SecurityConfigurerAdapter<O, B extends SecurityBuilder<O>>
implements SecurityConfigurer<O, B> {
    private B securityBuilder;
    private CompositeObjectPostProcessor objectPostProcessor = new CompositeObjectPostProcessor();

    @Override
    public void init(B builder) throws Exception {
    }

    @Override
    public void configure(B builder) throws Exception {
    }

    public B and() {
        return this.getBuilder();
    }

    protected final B getBuilder() {
        if (this.securityBuilder == null) {
            throw new IllegalStateException("securityBuilder cannot be null");
        }
        return this.securityBuilder;
    }

    protected <T> T postProcess(T object) {
        return (T)this.objectPostProcessor.postProcess(object);
    }

    public void addObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
        this.objectPostProcessor.addObjectPostProcessor(objectPostProcessor);
    }

    public void setBuilder(B builder) {
        this.securityBuilder = builder;
    }

    private static final class CompositeObjectPostProcessor
    implements ObjectPostProcessor<Object> {
        private List<ObjectPostProcessor<?>> postProcessors = new ArrayList();

        private CompositeObjectPostProcessor() {
        }

        @Override
        public Object postProcess(Object object) {
            for (ObjectPostProcessor<?> opp : this.postProcessors) {
                Class<?> oppClass = opp.getClass();
                Class oppType = GenericTypeResolver.resolveTypeArgument(oppClass, ObjectPostProcessor.class);
                if (oppType != null && !oppType.isAssignableFrom(object.getClass())) continue;
                object = opp.postProcess(object);
            }
            return object;
        }

        private boolean addObjectPostProcessor(ObjectPostProcessor<?> objectPostProcessor) {
            boolean result = this.postProcessors.add(objectPostProcessor);
            this.postProcessors.sort((Comparator<ObjectPostProcessor<?>>)AnnotationAwareOrderComparator.INSTANCE);
            return result;
        }
    }
}

