/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.dsl;

import java.io.File;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.dsl.MessageProducerSpec;
import org.springframework.integration.file.config.FileTailInboundChannelAdapterFactoryBean;
import org.springframework.integration.file.tail.FileTailingMessageProducerSupport;
import org.springframework.messaging.MessageChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;

public class TailAdapterSpec
extends MessageProducerSpec<TailAdapterSpec, FileTailingMessageProducerSupport> {
    private final FileTailInboundChannelAdapterFactoryBean factoryBean = new FileTailInboundChannelAdapterFactoryBean();
    private MessageChannel outputChannel;
    private MessageChannel errorChannel;

    TailAdapterSpec() {
        super(null);
        this.factoryBean.setBeanFactory((BeanFactory)new DefaultListableBeanFactory());
    }

    TailAdapterSpec file(File file) {
        Assert.notNull((Object)file, (String)"'file' cannot be null");
        this.factoryBean.setFile(file);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec nativeOptions(String nativeOptions) {
        this.factoryBean.setNativeOptions(nativeOptions);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec enableStatusReader(boolean enableStatusReader) {
        this.factoryBean.setEnableStatusReader(enableStatusReader);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec idleEventInterval(long idleEventInterval) {
        this.factoryBean.setIdleEventInterval(idleEventInterval);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec taskExecutor(TaskExecutor taskExecutor) {
        this.factoryBean.setTaskExecutor(taskExecutor);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec taskScheduler(TaskScheduler taskScheduler) {
        this.factoryBean.setTaskScheduler(taskScheduler);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec delay(long delay) {
        this.factoryBean.setDelay(delay);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec fileDelay(long fileDelay) {
        this.factoryBean.setFileDelay(fileDelay);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec end(boolean end) {
        this.factoryBean.setEnd(end);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec reopen(boolean reopen) {
        this.factoryBean.setReopen(reopen);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec id(String id) {
        this.factoryBean.setBeanName(id);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec phase(int phase) {
        this.factoryBean.setPhase(phase);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec autoStartup(boolean autoStartup) {
        this.factoryBean.setAutoStartup(autoStartup);
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec outputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
        return (TailAdapterSpec)this._this();
    }

    public TailAdapterSpec errorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
        return (TailAdapterSpec)this._this();
    }

    protected FileTailingMessageProducerSupport doGet() {
        if (this.outputChannel == null) {
            this.factoryBean.setOutputChannel((MessageChannel)new NullChannel());
        }
        FileTailingMessageProducerSupport tailingMessageProducerSupport = null;
        try {
            this.factoryBean.afterPropertiesSet();
            tailingMessageProducerSupport = (FileTailingMessageProducerSupport)((Object)this.factoryBean.getObject());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (this.errorChannel != null) {
            tailingMessageProducerSupport.setErrorChannel(this.errorChannel);
        }
        tailingMessageProducerSupport.setOutputChannel(this.outputChannel);
        return tailingMessageProducerSupport;
    }
}

