/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.util.Optional;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class Java8Utils {
    private static boolean OPTIONAL_PRESENT = ClassUtils.isPresent((String)"java.util.Optional", (ClassLoader)OptionalValueAccessor.class.getClassLoader());

    Java8Utils() {
    }

    static boolean isJava8Optional(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return OPTIONAL_PRESENT && OptionalValueAccessor.isOptional(type);
    }

    static boolean isJava8Optional(Object source) {
        return OPTIONAL_PRESENT && OptionalValueAccessor.isOptional(source);
    }

    static Object unwrapJava8Optional(Object source) {
        return OPTIONAL_PRESENT && Java8Utils.isJava8Optional(source) ? OptionalValueAccessor.unwrapOptional(source) : source;
    }

    private static class OptionalValueAccessor {
        private OptionalValueAccessor() {
        }

        static boolean isOptional(Class<?> type) {
            return Optional.class.isAssignableFrom(type);
        }

        static boolean isOptional(Object source) {
            return Optional.class.isInstance(source);
        }

        static Object unwrapOptional(Object source) {
            return ((Optional)source).orElse(null);
        }
    }
}

