/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data.json.converter.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.geode.data.json.converter.support.JacksonObjectToJsonConverter;
import org.springframework.geode.pdx.PdxInstanceBuilder;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JSONFormatterPdxToJsonConverter
extends JacksonObjectToJsonConverter {
    @Override
    @Nullable
    public final String convert(@Nullable Object source) {
        return Optional.ofNullable(source).filter(PdxInstance.class::isInstance).map(PdxInstance.class::cast).map(this::convertPdxToJson).orElseGet(() -> this.convertPojoToJson(source));
    }

    @Nullable
    protected String convertPojoToJson(Object source) {
        return super.convert(source);
    }

    @NonNull
    protected String convertPdxToJson(@NonNull PdxInstance pdxInstance) {
        return this.decorate(pdxInstance, this.jsonFormatterToJson(pdxInstance));
    }

    @NonNull
    String jsonFormatterToJson(@NonNull PdxInstance pdxInstance) {
        return JSONFormatter.toJSON((PdxInstance)pdxInstance);
    }

    @NonNull
    protected PdxInstance decorate(@NonNull PdxInstance pdxInstance) {
        if (this.isMissingObjectTypeMetadata(pdxInstance)) {
            String pdxInstanceClassName = pdxInstance.getClassName();
            Assert.isTrue((boolean)this.hasValidClassName(pdxInstance), () -> String.format("Class name [%s] is required and cannot be equal to [%s]", pdxInstanceClassName, "__GEMFIRE_JSON"));
            pdxInstance = this.newPdxInstanceBuilder().copy(pdxInstance).writeString("@type", pdxInstanceClassName).create();
        }
        return pdxInstance;
    }

    @NonNull
    PdxInstanceBuilder newPdxInstanceBuilder() {
        return PdxInstanceBuilder.create();
    }

    @NonNull
    protected String decorate(@NonNull PdxInstance pdxInstance, @NonNull String json) {
        if (this.isDecorationRequired(pdxInstance, json)) {
            try {
                ObjectMapper objectMapper = this.newObjectMapper(json);
                JsonNode jsonNode = objectMapper.readTree(json);
                if (this.isMissingObjectTypeMetadata(jsonNode)) {
                    ((ObjectNode)jsonNode).put("@type", pdxInstance.getClassName());
                    json = objectMapper.writeValueAsString((Object)jsonNode);
                }
                return json;
            }
            catch (JsonProcessingException cause) {
                if (this.hasValidClassName(pdxInstance)) {
                    return this.convertPojoToJson(pdxInstance.getObject());
                }
                String message = String.format("Failed to parse JSON [%s]", json);
                throw new DataRetrievalFailureException(message, (Throwable)cause);
            }
        }
        return json;
    }

    boolean hasValidClassName(@Nullable PdxInstance pdxInstance) {
        return Optional.ofNullable(pdxInstance).map(PdxInstance::getClassName).filter(StringUtils::hasText).filter(className -> !"__GEMFIRE_JSON".equals(className)).isPresent();
    }

    private boolean isDecorationRequired(@Nullable PdxInstance pdxInstance, @Nullable String json) {
        return this.isMissingObjectTypeMetadata(pdxInstance) && this.isValidJson(json);
    }

    private boolean isMissingObjectTypeMetadata(@Nullable JsonNode node) {
        return this.isObjectNode(node) && !node.has("@type");
    }

    private boolean isMissingObjectTypeMetadata(@Nullable PdxInstance pdxInstance) {
        return pdxInstance != null && !pdxInstance.hasField("@type");
    }

    boolean isObjectNode(@Nullable JsonNode node) {
        return node != null && (node.isObject() || node instanceof ObjectNode);
    }

    boolean isValidJson(@Nullable String json) {
        return StringUtils.hasText((String)json);
    }
}

