/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.geode.pdx.PdxInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class ObjectUtils
extends org.springframework.util.ObjectUtils {
    private static final Logger logger = LoggerFactory.getLogger(ObjectUtils.class);

    @Nullable
    public static <T> T asType(@Nullable Object source, @NonNull Class<T> type) {
        Assert.notNull(type, (String)"Class type must not be null");
        Object target = source instanceof PdxInstance ? ((PdxInstance)source).getObject() : source;
        return (T)(target == null ? null : Optional.of(target).filter(type::isInstance).map(type::cast).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Object [%s] is not an instance of type [%s]", (Object[])new Object[]{ObjectUtils.nullSafeClassName((Object)target), type.getName()})));
    }

    @Nullable
    public static <T> T doOperationSafely(@NonNull ExceptionThrowingOperation<T> operation) {
        return ObjectUtils.doOperationSafely(operation, null);
    }

    @Nullable
    public static <T> T doOperationSafely(@NonNull ExceptionThrowingOperation<T> operation, @NonNull T defaultValue) {
        Supplier<Object> valueSupplier = () -> defaultValue;
        return (T)ObjectUtils.doOperationSafely(operation, valueSupplier);
    }

    public static <T> T doOperationSafely(@NonNull ExceptionThrowingOperation<T> operation, @NonNull Supplier<T> valueSupplier) {
        Function<Throwable, Object> exceptionHandlingFunction = cause -> ObjectUtils.returnValueThrowOnNull(valueSupplier.get(), RuntimeExceptionFactory.newIllegalStateException((Throwable)cause, (String)"Failed to execute operation", (Object[])new Object[0]));
        return (T)ObjectUtils.doOperationSafely(operation, exceptionHandlingFunction);
    }

    public static <T> T doOperationSafely(@NonNull ExceptionThrowingOperation<T> operation, @NonNull Function<Throwable, T> exceptionHandlingFunction) {
        try {
            return operation.run();
        }
        catch (Exception cause) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Failed to execute operation [%s]", operation), (Throwable)cause);
            }
            return exceptionHandlingFunction.apply(cause);
        }
    }

    public static Optional<Method> findMethod(@NonNull Class<?> type, @NonNull String methodName, Object ... args) {
        return Arrays.stream(ArrayUtils.nullSafeArray((Object[])type.getDeclaredMethods(), Method.class)).filter(ObjectUtils.methodNameMatchesPredicate(methodName)).filter(ObjectUtils.argumentsMatchParameterTypesPredicate(args)).findFirst();
    }

    private static Predicate<Method> argumentsMatchParameterTypesPredicate(Object ... args) {
        return method -> {
            Class[] parameterTypes = (Class[])ArrayUtils.nullSafeArray((Object[])method.getParameterTypes(), Class.class);
            Object[] arguments = ArrayUtils.nullSafeArray((Object[])args, Object.class);
            if (arguments.length != parameterTypes.length) {
                return false;
            }
            for (int index = 0; index < parameterTypes.length; ++index) {
                Object argument = arguments[index];
                if (argument == null || parameterTypes[index].isInstance(argument)) continue;
                return false;
            }
            return true;
        };
    }

    private static Predicate<Method> methodNameMatchesPredicate(String methodName) {
        return method -> method.getName().equals(methodName);
    }

    public static <T> T get(Object obj, String fieldName) {
        Assert.notNull((Object)obj, (String)"Object is required");
        Assert.hasText((String)fieldName, (String)String.format("Field name [%s] is required", fieldName));
        Field field = ReflectionUtils.findField(obj.getClass(), (String)fieldName);
        if (field != null) {
            field = ObjectUtils.makeAccessible(field);
            return ObjectUtils.get(obj, field);
        }
        throw RuntimeExceptionFactory.newIllegalArgumentException((String)"No field with name [%s] exists on object of type [%s]", (Object[])new Object[]{fieldName, ObjectUtils.nullSafeClassName((Object)obj)});
    }

    public static <T> T get(Object obj, Field field) {
        Assert.notNull((Object)obj, (String)"Object is required");
        Assert.notNull((Object)field, (String)"Field is required");
        return ObjectUtils.doOperationSafely(() -> field.get(obj), null);
    }

    public static <T> T initialize(@Nullable T target, @NonNull Supplier<T> supplier) {
        return target != null ? target : supplier.get();
    }

    public static <T> T invoke(Object obj, String methodName) {
        return (T)Optional.ofNullable(obj).map(Object::getClass).map(type -> ReflectionUtils.findMethod((Class)type, (String)methodName)).map(ObjectUtils::makeAccessible).map(method -> ReflectionUtils.invokeMethod((Method)method, (Object)obj)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"Method [%1$s] on Object of type [%2$s] not found", (Object[])new Object[]{methodName, org.springframework.util.ObjectUtils.nullSafeClassName((Object)obj)}));
    }

    public static Constructor<?> makeAccessible(@NonNull Constructor<?> constructor) {
        ReflectionUtils.makeAccessible(constructor);
        return constructor;
    }

    public static Field makeAccessible(Field field) {
        ReflectionUtils.makeAccessible((Field)field);
        return field;
    }

    public static Method makeAccessible(Method method) {
        ReflectionUtils.makeAccessible((Method)method);
        return method;
    }

    public static <T> T returnValueThrowOnNull(T value) {
        return ObjectUtils.returnValueThrowOnNull(value, RuntimeExceptionFactory.newIllegalArgumentException((String)"Value must not be null", (Object[])new Object[0]));
    }

    public static <T> T returnValueThrowOnNull(T value, RuntimeException exception) {
        if (value == null) {
            throw exception;
        }
        return value;
    }

    public static <T> T resolveInvocationTarget(T target, Method method) {
        return Modifier.isStatic(method.getModifiers()) ? null : (T)target;
    }

    @FunctionalInterface
    public static interface ExceptionThrowingOperation<T> {
        public T run() throws Exception;
    }
}

