/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.context.annotation;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class RefreshableAnnotationConfigApplicationContext
extends AbstractRefreshableConfigApplicationContext
implements AnnotationConfigRegistry {
    protected static final boolean DEFAULT_COPY_CONFIGURATION = false;
    protected static final boolean USE_DEFAULT_FILTERS = true;
    @Nullable
    private BeanNameGenerator beanNameGenerator;
    @Nullable
    private volatile DefaultListableBeanFactory beanFactory;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Set<String> basePackages = new LinkedHashSet<String>();
    private final Set<Class<?>> componentClasses = new LinkedHashSet();
    @Nullable
    private ScopeMetadataResolver scopeMetadataResolver;

    public RefreshableAnnotationConfigApplicationContext() {
        this(null);
    }

    public RefreshableAnnotationConfigApplicationContext(@Nullable ApplicationContext parent) {
        super(parent);
        this.refreshBeanFactory();
    }

    public void setBeanNameGenerator(@Nullable BeanNameGenerator beanNameGenerator) {
        this.beanNameGenerator = beanNameGenerator;
    }

    protected Optional<BeanNameGenerator> getBeanNameGenerator() {
        return Optional.ofNullable(this.beanNameGenerator);
    }

    @NonNull
    protected Logger getLogger() {
        return this.logger;
    }

    public void setScopeMetadataResolver(@Nullable ScopeMetadataResolver scopeMetadataResolver) {
        this.scopeMetadataResolver = scopeMetadataResolver;
    }

    public Optional<ScopeMetadataResolver> getScopeMetadataResolver() {
        return Optional.ofNullable(this.scopeMetadataResolver);
    }

    protected boolean isCopyConfigurationEnabled() {
        return false;
    }

    protected boolean isUsingDefaultFilters() {
        return true;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws BeansException {
        AnnotatedBeanDefinitionReader reader = this.configure(this.newAnnotatedBeanDefinitionReader((BeanDefinitionRegistry)beanFactory));
        ClassPathBeanDefinitionScanner scanner = this.configure(this.newClassBeanDefinitionScanner((BeanDefinitionRegistry)beanFactory));
        this.getBeanNameGenerator().ifPresent(beanNameGenerator -> {
            reader.setBeanNameGenerator(beanNameGenerator);
            scanner.setBeanNameGenerator(beanNameGenerator);
            beanFactory.registerSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator", beanNameGenerator);
        });
        this.getScopeMetadataResolver().ifPresent(scopeMetadataResolver -> {
            reader.setScopeMetadataResolver(scopeMetadataResolver);
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        });
        Arrays.stream(ArrayUtils.nullSafeArray((Object[])this.getConfigLocations(), String.class)).forEach(configLocation -> {
            block2: {
                try {
                    Class type = ClassUtils.forName((String)configLocation, (ClassLoader)this.getClassLoader());
                    this.getLogger().trace("Registering [{}]", configLocation);
                    reader.register(new Class[]{type});
                }
                catch (ClassNotFoundException cause) {
                    this.getLogger().trace(String.format("Could not load class for config location [%s] - trying package scan.", configLocation), (Throwable)cause);
                    if (scanner.scan(new String[]{configLocation}) != 0) break block2;
                    this.getLogger().debug("No component classes found for specified class/package [{}]", configLocation);
                }
            }
        });
    }

    private AnnotatedBeanDefinitionReader configure(AnnotatedBeanDefinitionReader reader) {
        Set<Class<?>> componentClasses = this.componentClasses;
        if (!componentClasses.isEmpty()) {
            this.getLogger().debug("Registering component classes: {}", componentClasses);
            reader.register(ClassUtils.toClassArray(componentClasses));
        }
        return reader;
    }

    private ClassPathBeanDefinitionScanner configure(ClassPathBeanDefinitionScanner scanner) {
        Set<String> basePackages = this.basePackages;
        if (!basePackages.isEmpty()) {
            this.getLogger().debug("Scanning base packages: {}", basePackages);
            scanner.scan(StringUtils.toStringArray(basePackages));
        }
        return scanner;
    }

    protected AnnotatedBeanDefinitionReader newAnnotatedBeanDefinitionReader(BeanDefinitionRegistry registry) {
        return new AnnotatedBeanDefinitionReader(registry, (Environment)this.getEnvironment());
    }

    protected ClassPathBeanDefinitionScanner newClassBeanDefinitionScanner(BeanDefinitionRegistry registry) {
        return new ClassPathBeanDefinitionScanner(registry, this.isUsingDefaultFilters(), (Environment)this.getEnvironment());
    }

    protected void onRefresh() {
        super.onRefresh();
        ConfigurableListableBeanFactory currentBeanFactory = this.getBeanFactory();
        if (this.beanFactory != null) {
            Arrays.stream(ArrayUtils.nullSafeArray((Object[])this.beanFactory.getSingletonNames(), String.class)).filter(singletonBeanName -> !currentBeanFactory.containsSingleton(singletonBeanName)).forEach(singletonBeanName -> currentBeanFactory.registerSingleton(singletonBeanName, this.beanFactory.getSingleton(singletonBeanName)));
            if (this.isCopyConfigurationEnabled()) {
                currentBeanFactory.copyConfigurationFrom((ConfigurableBeanFactory)this.beanFactory);
            }
        }
    }

    protected void prepareRefresh() {
        this.beanFactory = (DefaultListableBeanFactory)SpringUtils.safeGetValue(() -> ((RefreshableAnnotationConfigApplicationContext)this).getBeanFactory());
        super.prepareRefresh();
    }

    public void register(Class<?> ... componentClasses) {
        Arrays.stream(ArrayUtils.nullSafeArray((Object[])componentClasses, Class.class)).filter(Objects::nonNull).forEach(this.componentClasses::add);
    }

    public void scan(String ... basePackages) {
        Arrays.stream(ArrayUtils.nullSafeArray((Object[])basePackages, String.class)).filter(StringUtils::hasText).forEach(this.basePackages::add);
    }
}

