/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.config.annotation;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.client.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.geode.cache.SimpleCacheResolver;
import org.springframework.geode.config.annotation.ClusterAvailableConfiguration;
import org.springframework.geode.config.annotation.ClusterNotAvailableConfiguration;
import org.springframework.geode.config.annotation.ClusterNotAvailableException;
import org.springframework.geode.config.annotation.EnableClusterAware;
import org.springframework.geode.core.util.ObjectUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={ClusterAvailableConfiguration.class, ClusterNotAvailableConfiguration.class})
public class ClusterAwareConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    static final boolean DEFAULT_CLUSTER_AWARE_CONDITION_MATCH = false;
    static final boolean DEFAULT_CLUSTER_AWARE_CONDITION_STRICT_MATCH = false;
    static final int DEFAULT_CACHE_SERVER_PORT = 40404;
    static final int DEFAULT_LOCATOR_PORT = 10334;
    static final int DEFAULT_TIMEOUT_IN_MILLISECONDS = 500;
    static final ClientRegionShortcut LOCAL_CLIENT_REGION_SHORTCUT = ClientRegionShortcut.LOCAL;
    static final String LOCALHOST = "localhost";
    static final String MATCHING_PROPERTY_PATTERN = "spring\\.data\\.gemfire\\.pool\\..*locators|servers";
    static final String STRICT_MATCH_ATTRIBUTE_NAME = "strictMatch";
    static final String CLUSTER_AWARE_CONFIGURATION_PROPERTY_SOURCE_NAME = ClusterAwareConfiguration.class.getSimpleName().concat("PropertySource");
    static final String SPRING_BOOT_DATA_GEMFIRE_CLUSTER_CONDITION_MATCH_PROPERTY = "spring.boot.data.gemfire.cluster.condition.match";
    static final String SPRING_BOOT_DATA_GEMFIRE_CLUSTER_CONDITION_MATCH_STRICT_PROPERTY = "spring.boot.data.gemfire.cluster.condition.match.strict";
    static final String SPRING_DATA_GEMFIRE_CACHE_CLIENT_REGION_SHORTCUT_PROPERTY = "spring.data.gemfire.cache.client.region.shortcut";
    private static final AtomicBoolean strictMatchConfiguration = new AtomicBoolean(false);
    private static final Function<ConditionContext, Boolean> configuredMatchFunction = conditionContext -> Optional.ofNullable(conditionContext).map(ConditionContext::getEnvironment).map(environment -> (Boolean)environment.getProperty(SPRING_BOOT_DATA_GEMFIRE_CLUSTER_CONDITION_MATCH_PROPERTY, Boolean.class, (Object)false)).orElse(false);
    private static final Logger logger = LoggerFactory.getLogger(ClusterAwareConfiguration.class);

    @NonNull
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableClusterAware.class;
    }

    protected boolean isStrictMatchConfigured(@NonNull AnnotationAttributes enableClusterAwareAttributes) {
        return enableClusterAwareAttributes != null && Boolean.TRUE.equals(enableClusterAwareAttributes.getBoolean(STRICT_MATCH_ATTRIBUTE_NAME));
    }

    public void setImportMetadata(@NonNull AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes enableClusterAwareAttributes = this.getAnnotationAttributes(importMetadata);
            strictMatchConfiguration.set(this.isStrictMatchConfigured(enableClusterAwareAttributes));
        }
    }

    static /* synthetic */ AtomicBoolean access$200() {
        return strictMatchConfiguration;
    }

    protected static class SocketCreationException
    extends RuntimeException {
        protected SocketCreationException() {
        }

        protected SocketCreationException(String message) {
            super(message);
        }

        protected SocketCreationException(Throwable cause) {
            super(cause);
        }

        protected SocketCreationException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class PoolConnectionEndpoint
    extends ConnectionEndpoint {
        private Pool pool;

        protected static PoolConnectionEndpoint from(@NonNull ConnectionEndpoint connectionEndpoint) {
            return new PoolConnectionEndpoint(connectionEndpoint.getHost(), connectionEndpoint.getPort());
        }

        PoolConnectionEndpoint(@NonNull String host, int port) {
            super(host, port);
        }

        public Optional<Pool> getPool() {
            return Optional.ofNullable(this.pool);
        }

        @NonNull
        public PoolConnectionEndpoint with(@Nullable Pool pool) {
            this.pool = pool;
            return this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PoolConnectionEndpoint)) {
                return false;
            }
            PoolConnectionEndpoint that = (PoolConnectionEndpoint)((Object)obj);
            return super.equals((Object)that) && this.getPool().equals(that.getPool());
        }

        public int hashCode() {
            int hashValue = super.hashCode();
            hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode(this.getPool());
            return hashValue;
        }

        public String toString() {
            return String.format("ConnectionEndpoint [%1$s] from Pool [%2$s]", super.toString(), this.getPool().map(Pool::getName).orElse(""));
        }
    }

    protected static class ConnectionEndpointListBuilder {
        protected ConnectionEndpointListBuilder() {
        }

        @NonNull
        protected static ConnectionEndpointList from(@NonNull Pool pool) {
            ConnectionEndpointList list = new ConnectionEndpointList();
            if (pool != null) {
                HashSet poolSocketAddresses = new HashSet();
                ConnectionEndpointListBuilder.collect(poolSocketAddresses, pool.getLocators());
                ConnectionEndpointListBuilder.collect(poolSocketAddresses, pool.getOnlineLocators());
                ConnectionEndpointListBuilder.collect(poolSocketAddresses, pool.getServers());
                poolSocketAddresses.stream().map(ConnectionEndpoint::from).map(PoolConnectionEndpoint::from).map(it -> it.with(pool)).forEach(arg_0 -> ((ConnectionEndpointList)list).add(arg_0));
            }
            return list;
        }

        private static <T extends Collection<InetSocketAddress>> T collect(@NonNull T collection, @NonNull Collection<InetSocketAddress> socketAddressesToCollect) {
            CollectionUtils.nullSafeCollection(socketAddressesToCollect).stream().filter(Objects::nonNull).forEach(collection::add);
            return collection;
        }
    }

    public static class ClusterAwareCondition
    implements Condition {
        private static final AtomicReference<Boolean> clusterAvailable = new AtomicReference<Object>(null);
        protected static final String RUNTIME_ENVIRONMENT_NAME = "Apache Geode-based Cluster on Bare Metal";

        @NonNull
        private static ApplicationListener<ContextClosedEvent> clusterAwareConditionResetOnContextClosedApplicationListener() {
            return contextClosedEvent -> ClusterAwareCondition.reset();
        }

        public static boolean isAvailable() {
            return Boolean.TRUE.equals(clusterAvailable.get());
        }

        public static void reset() {
            ClusterAwareCondition.set(null);
        }

        protected static void set(@Nullable Boolean available) {
            clusterAvailable.set(available);
        }

        public static boolean wasClusterAvailabilityEvaluated() {
            return clusterAvailable.get() != null;
        }

        protected String getRuntimeEnvironmentName() {
            return RUNTIME_ENVIRONMENT_NAME;
        }

        public synchronized boolean matches(@NonNull ConditionContext conditionContext, @NonNull AnnotatedTypeMetadata typeMetadata) {
            boolean matches = this.isMatch(conditionContext) || this.doCachedMatch(conditionContext);
            boolean strictMatch = this.isStrictMatch(conditionContext, typeMetadata);
            this.failOnStrictMatchAndNoMatches(strictMatch, matches);
            return matches;
        }

        boolean isMatch(@NonNull ConditionContext conditionContext) {
            return ClusterAwareCondition.isAvailable() || (Boolean)configuredMatchFunction.apply(conditionContext) != false;
        }

        protected boolean isStrictMatch(@NonNull ConditionContext conditionContext, @NonNull AnnotatedTypeMetadata typeMetadata) {
            Environment environment = conditionContext.getEnvironment();
            Function<ConfigurableListableBeanFactory, Boolean> isStrictMatchEnabledFunction = ClusterAwareCondition::lambda$isStrictMatch$4;
            return (Boolean)environment.getProperty(ClusterAwareConfiguration.SPRING_BOOT_DATA_GEMFIRE_CLUSTER_CONDITION_MATCH_STRICT_PROPERTY, Boolean.class, (Object)isStrictMatchEnabledFunction.apply(conditionContext.getBeanFactory()));
        }

        protected boolean isStrictMatchAndNoMatches(boolean strictMatch, boolean matches) {
            return strictMatch && !matches;
        }

        protected void failOnStrictMatchAndNoMatches(boolean strictMatch, boolean matches) {
            if (this.isStrictMatchAndNoMatches(strictMatch, matches)) {
                String message = String.format("Failed to find available cluster in [%1$s] when strictMatch was [%2$s]", this.getRuntimeEnvironmentName(), strictMatch);
                throw new ClusterNotAvailableException(message);
            }
        }

        protected boolean doCachedMatch(@NonNull ConditionContext conditionContext) {
            Supplier<Boolean> evaluateConditionMatches = () -> {
                this.registerApplicationListener(conditionContext);
                return this.doMatch(conditionContext);
            };
            UnaryOperator clusterAvailableUpdateFunction = currentClusterAvailable -> ObjectUtils.initialize(currentClusterAvailable, evaluateConditionMatches);
            return clusterAvailable.updateAndGet(clusterAvailableUpdateFunction);
        }

        @NonNull
        protected ConditionContext registerApplicationListener(@NonNull ConditionContext conditionContext) {
            Optional.ofNullable(conditionContext).map(ConditionContext::getResourceLoader).filter(ConfigurableApplicationContext.class::isInstance).map(ConfigurableApplicationContext.class::cast).ifPresent(applicationContext -> applicationContext.addApplicationListener(ClusterAwareCondition.clusterAwareConditionResetOnContextClosedApplicationListener()));
            return conditionContext;
        }

        protected boolean doMatch(@NonNull ConditionContext conditionContext) {
            Environment environment = conditionContext.getEnvironment();
            ConnectionEndpointList connectionEndpoints = this.getConnectionEndpoints(environment);
            int connectionCount = this.countConnections(connectionEndpoints);
            this.configureTopology(environment, connectionEndpoints, connectionCount);
            this.logRuntimeEnvironment(this.getLogger(), connectionCount);
            return this.isMatch(connectionEndpoints, connectionCount);
        }

        boolean isMatch(@NonNull ConnectionEndpointList connectionEndpoints, int connectionCount) {
            return this.isConnected(connectionCount);
        }

        @NonNull
        protected Logger getLogger() {
            return logger;
        }

        protected ConnectionEndpointList getConnectionEndpoints(@NonNull Environment environment) {
            return new ConnectionEndpointList(this.getDefaultConnectionEndpoints(environment)).add(this.getConfiguredConnectionEndpoints(environment)).add(this.getPooledConnectionEndpoints(environment));
        }

        protected List<ConnectionEndpoint> getDefaultConnectionEndpoints(@NonNull Environment environment) {
            return Arrays.asList(new ConnectionEndpoint(ClusterAwareConfiguration.LOCALHOST, 40404), new ConnectionEndpoint(ClusterAwareConfiguration.LOCALHOST, 10334));
        }

        protected List<ConnectionEndpoint> getConfiguredConnectionEndpoints(@NonNull Environment environment) {
            ConfigurableEnvironment configurableEnvironment;
            MutablePropertySources propertySources;
            ArrayList<ConnectionEndpoint> connectionEndpoints = new ArrayList<ConnectionEndpoint>();
            if (environment instanceof ConfigurableEnvironment && (propertySources = (configurableEnvironment = (ConfigurableEnvironment)environment).getPropertySources()) != null) {
                Pattern pattern = Pattern.compile(ClusterAwareConfiguration.MATCHING_PROPERTY_PATTERN);
                for (PropertySource propertySource : propertySources) {
                    if (!(propertySource instanceof EnumerablePropertySource)) continue;
                    EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                    Object[] propertyNames = enumerablePropertySource.getPropertyNames();
                    Arrays.stream(ArrayUtils.nullSafeArray((Object[])propertyNames, String.class)).filter(StringUtils::hasText).filter(propertyName -> pattern.matcher((CharSequence)propertyName).find()).forEach(propertyName -> {
                        String propertyValue = environment.getProperty(propertyName);
                        if (StringUtils.hasText((String)propertyValue)) {
                            int defaultPort = propertyName.toLowerCase().contains("servers") ? 40404 : 10334;
                            String[] propertyValueArray = propertyValue.split(",");
                            ConnectionEndpointList list = ConnectionEndpointList.parse((int)defaultPort, (String[])propertyValueArray);
                            connectionEndpoints.addAll((Collection<ConnectionEndpoint>)list);
                        }
                    });
                }
            }
            return connectionEndpoints;
        }

        protected List<ConnectionEndpoint> getPooledConnectionEndpoints(@NonNull Environment environment) {
            ArrayList<ConnectionEndpoint> pooledConnectionEndpoints = new ArrayList<ConnectionEndpoint>();
            this.getPoolsFromApacheGeode().stream().filter(Objects::nonNull).map(ConnectionEndpointListBuilder::from).forEach(pooledConnectionEndpoints::addAll);
            return pooledConnectionEndpoints;
        }

        protected Collection<Pool> getPoolsFromApacheGeode() {
            HashSet<Pool> pools = new HashSet<Pool>();
            pools.addAll(this.getPoolsFromClientCache());
            pools.addAll(this.getPoolsFromPoolManager());
            return pools;
        }

        Collection<Pool> getPoolsFromClientCache() {
            return SimpleCacheResolver.getInstance().resolveClientCache().map(ClientCache::getDefaultPool).map(Collections::singleton).orElseGet(Collections::emptySet);
        }

        Collection<Pool> getPoolsFromPoolManager() {
            Map namedPools = PoolManager.getAll();
            return CollectionUtils.nullSafeMap((Map)namedPools).values().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }

        protected int countConnections(@NonNull ConnectionEndpointList connectionEndpoints) {
            int count = 0;
            for (ConnectionEndpoint connectionEndpoint : connectionEndpoints) {
                try {
                    Socket socket = this.connect(connectionEndpoint);
                    Throwable throwable = null;
                    try {
                        count += this.isConnected(socket) ? 1 : 0;
                        if (!this.getLogger().isInfoEnabled()) continue;
                        this.getLogger().info("Successfully connected to {}", (Object)connectionEndpoint);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (socket == null) continue;
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        socket.close();
                    }
                }
                catch (IOException | SocketCreationException cause) {
                    if (this.getLogger().isInfoEnabled()) {
                        this.getLogger().info("Failed to connect to {}", (Object)connectionEndpoint);
                    }
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Connection failed because:", (Throwable)cause);
                }
            }
            return count;
        }

        protected boolean isConnected(@NonNull Socket socket) {
            return socket != null && socket.isConnected();
        }

        @NonNull
        protected Socket connect(@NonNull ConnectionEndpoint connectionEndpoint) throws IOException {
            InetSocketAddress socketAddress = connectionEndpoint.toInetSocketAddress();
            Socket socket = connectionEndpoint instanceof PoolConnectionEndpoint ? this.newSocket((PoolConnectionEndpoint)connectionEndpoint) : this.newSocket(connectionEndpoint);
            socket.connect(socketAddress, 500);
            return socket;
        }

        @NonNull
        protected Socket newSocket(@NonNull ConnectionEndpoint connectionEndpoint) throws IOException {
            Socket socket = new Socket();
            socket.setKeepAlive(false);
            socket.setReuseAddress(true);
            socket.setSoLinger(false, 0);
            return socket;
        }

        @NonNull
        protected Socket newSocket(@NonNull PoolConnectionEndpoint poolConnectionEndpoint) {
            Function<Throwable, Socket> ioExceptionHandlingFunction = cause -> {
                String message = String.format("Failed to create Socket from PoolConnectionEndpoint [%s]", new Object[]{poolConnectionEndpoint});
                throw new SocketCreationException(message, (Throwable)cause);
            };
            return poolConnectionEndpoint.getPool().map(Pool::getSocketFactory).map(socketFactory -> ObjectUtils.doOperationSafely(() -> ((SocketFactory)socketFactory).createSocket(), ioExceptionHandlingFunction)).orElseGet(() -> ObjectUtils.doOperationSafely(() -> this.newSocket((ConnectionEndpoint)poolConnectionEndpoint), ioExceptionHandlingFunction));
        }

        protected boolean close(@Nullable Socket socket) {
            return ObjectUtils.doOperationSafely(() -> {
                if (socket != null) {
                    socket.close();
                    return true;
                }
                return false;
            }, cause -> false);
        }

        protected boolean isConnected(int connectionCount) {
            return connectionCount > 0;
        }

        protected boolean isNotConnected(int connectionCount) {
            return !this.isConnected(connectionCount);
        }

        private void configureEnvironment(@NonNull Environment environment) {
            if (environment != null && !environment.containsProperty(ClusterAwareConfiguration.SPRING_DATA_GEMFIRE_CACHE_CLIENT_REGION_SHORTCUT_PROPERTY)) {
                if (environment instanceof ConfigurableEnvironment) {
                    MutablePropertySources propertySources = ((ConfigurableEnvironment)environment).getPropertySources();
                    propertySources.addFirst((PropertySource)new MapPropertySource(CLUSTER_AWARE_CONFIGURATION_PROPERTY_SOURCE_NAME, Collections.singletonMap(ClusterAwareConfiguration.SPRING_DATA_GEMFIRE_CACHE_CLIENT_REGION_SHORTCUT_PROPERTY, LOCAL_CLIENT_REGION_SHORTCUT.name())));
                } else {
                    System.setProperty(ClusterAwareConfiguration.SPRING_DATA_GEMFIRE_CACHE_CLIENT_REGION_SHORTCUT_PROPERTY, LOCAL_CLIENT_REGION_SHORTCUT.name());
                }
            }
        }

        protected void configureTopology(@NonNull Environment environment, @NonNull ConnectionEndpointList connectionEndpoints, int connectionCount) {
            if (this.isNotConnected(connectionCount)) {
                this.configureEnvironment(environment);
            }
        }

        protected void logConnectedRuntimeEnvironment(@NonNull Logger logger) {
            if (logger.isInfoEnabled()) {
                logger.info("Spring Boot application is running in a client/server topology using a standalone Apache Geode-based cluster");
            }
        }

        protected void logConnectedRuntimeEnvironment(@NonNull Logger logger, int connectionCount) {
            if (logger.isInfoEnabled()) {
                logger.info("Cluster was found; Auto-configuration made [{}] successful connection(s)", (Object)connectionCount);
            }
            this.logConnectedRuntimeEnvironment(logger);
        }

        protected void logRuntimeEnvironment(@NonNull Logger logger, int connectionCount) {
            if (this.isConnected(connectionCount)) {
                this.logConnectedRuntimeEnvironment(logger, connectionCount);
            } else {
                this.logUnconnectedRuntimeEnvironment(logger);
            }
        }

        protected void logUnconnectedRuntimeEnvironment(@NonNull Logger logger) {
            if (logger.isInfoEnabled()) {
                logger.info("No cluster was found; Spring Boot application will run in standalone [LOCAL] mode unless strictMode is false and the application is running in a Cloud-managed Environment");
            }
        }

        /*
         * Unable to fully structure code
         */
        private static /* synthetic */ Boolean lambda$isStrictMatch$4(ConfigurableListableBeanFactory beanFactory) {
            block2: {
                strictMatchEnabled = ClusterAwareConfiguration.access$200().get();
                if (strictMatchEnabled) break block2;
                annotationName = EnableClusterAware.class.getName();
                if (beanFactory == null) ** GOTO lbl-1000
                if (Arrays.stream(ArrayUtils.nullSafeArray((Object[])beanFactory.getBeanDefinitionNames(), String.class)).map((Function<String, BeanDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getBeanDefinition(java.lang.String ), (Ljava/lang/String;)Lorg/springframework/beans/factory/config/BeanDefinition;)((ConfigurableListableBeanFactory)beanFactory)).filter((Predicate<BeanDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lorg/springframework/beans/factory/config/BeanDefinition;)Z)(AnnotatedBeanDefinition.class)).map((Function<BeanDefinition, AnnotatedBeanDefinition>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, cast(java.lang.Object ), (Lorg/springframework/beans/factory/config/BeanDefinition;)Lorg/springframework/beans/factory/annotation/AnnotatedBeanDefinition;)(AnnotatedBeanDefinition.class)).map((Function<AnnotatedBeanDefinition, AnnotationMetadata>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getMetadata(), (Lorg/springframework/beans/factory/annotation/AnnotatedBeanDefinition;)Lorg/springframework/core/type/AnnotationMetadata;)()).filter((Predicate<AnnotationMetadata>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$null$1(java.lang.String org.springframework.core.type.AnnotationMetadata ), (Lorg/springframework/core/type/AnnotationMetadata;)Z)((String)annotationName)).findFirst().map((Function<AnnotationMetadata, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$null$2(java.lang.String org.springframework.core.type.AnnotationMetadata ), (Lorg/springframework/core/type/AnnotationMetadata;)Ljava/util/Map;)((String)annotationName)).map((Function<Map, AnnotationAttributes>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, fromMap(java.util.Map ), (Ljava/util/Map;)Lorg/springframework/core/annotation/AnnotationAttributes;)()).map((Function<AnnotationAttributes, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$null$3(org.springframework.core.annotation.AnnotationAttributes ), (Lorg/springframework/core/annotation/AnnotationAttributes;)Ljava/lang/Boolean;)()).orElse(false).booleanValue()) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                strictMatchEnabled = v0;
            }
            return strictMatchEnabled;
        }

        private static /* synthetic */ Boolean lambda$null$3(AnnotationAttributes annotationAttributes) {
            return annotationAttributes.getBoolean(ClusterAwareConfiguration.STRICT_MATCH_ATTRIBUTE_NAME);
        }

        private static /* synthetic */ Map lambda$null$2(String annotationName, AnnotationMetadata annotationMetadata) {
            return annotationMetadata.getAnnotationAttributes(annotationName);
        }

        private static /* synthetic */ boolean lambda$null$1(String annotationName, AnnotationMetadata annotationMetadata) {
            return annotationMetadata.hasAnnotation(annotationName);
        }
    }
}

