/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.util.StringUtils;

public class VariableContext {
    private Map<PersistentPropertyPath<Neo4jPersistentProperty>, String> variables = new HashMap<PersistentPropertyPath<Neo4jPersistentProperty>, String>();

    public String getVariableFor(PersistentPropertyPath<Neo4jPersistentProperty> path) {
        if (this.variables.containsKey(path)) {
            return this.variables.get(path);
        }
        Neo4jPersistentProperty baseProperty = (Neo4jPersistentProperty)path.getBaseProperty();
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(this.getVariableFor(baseProperty.getOwner()));
        Neo4jPersistentProperty leaf = (Neo4jPersistentProperty)path.getLeafProperty();
        for (Neo4jPersistentProperty property : path) {
            if (!leaf.isRelationship() && leaf.equals(property)) continue;
            parts.add(property.getName());
        }
        String variable = StringUtils.collectionToDelimitedString(parts, (String)"_");
        this.variables.put(path, variable);
        return variable;
    }

    public String getVariableFor(Neo4jPersistentEntity<?> entity) {
        return StringUtils.uncapitalize((String)entity.getType().getSimpleName());
    }
}

