/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelatedToFieldAccessor;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.mapping.RelationshipInfo;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public class RelatedToCollectionFieldAccessorFactory
implements FieldAccessorFactory {
    protected Neo4jTemplate template;

    public RelatedToCollectionFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        if (!property.isRelationship()) {
            return false;
        }
        RelationshipInfo info = property.getRelationshipInfo();
        return info.isCollection() && info.isRelatedTo() && !info.isReadonly();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        RelationshipInfo relationshipInfo = property.getRelationshipInfo();
        Class targetType = relationshipInfo.getTargetType().getType();
        return new RelatedToCollectionFieldAccessor(relationshipInfo.getRelationshipType(), relationshipInfo.getDirection(), targetType, this.template, property);
    }

    public static class RelatedToCollectionFieldAccessor
    extends RelatedToFieldAccessor {
        public RelatedToCollectionFieldAccessor(RelationshipType type, Direction direction, Class<?> elementClass, Neo4jTemplate template, Neo4jPersistentProperty property) {
            super(elementClass, template, direction, type, property);
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            Node node = this.checkAndGetNode(entity);
            if (newVal == null) {
                return null;
            }
            Set<Node> targetNodes = this.createSetOfTargetNodes(newVal);
            this.removeMissingRelationships(node, targetNodes, this.property.getTargetType());
            this.createAddedRelationships(node, targetNodes);
            return this.createManagedSet(entity, (Set)newVal, this.property.obtainMappingPolicy(mappingPolicy));
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            this.checkAndGetNode(entity);
            MappingPolicy currentPolicy = this.property.obtainMappingPolicy(mappingPolicy);
            Set<Object> result = this.property.isTargetTypeEnforced() ? this.createEntitySetFromRelationshipEndNodesUsingTypeProperty(entity, currentPolicy) : this.createEntitySetFromRelationshipEndNodes(entity, currentPolicy);
            HashSet<Object> values = new HashSet<Object>();
            Class<?> targetType = this.property.getTargetType();
            for (Object value : result) {
                if (targetType != null && !targetType.isAssignableFrom(value.getClass())) continue;
                values.add(value);
            }
            return DoReturn.doReturn(this.createManagedSet(entity, values, currentPolicy));
        }

        @Override
        public Object getDefaultValue() {
            if (List.class.isAssignableFrom(this.property.getType())) {
                return new ArrayList();
            }
            return new HashSet();
        }
    }
}

