/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.Tuple;
import java.lang.reflect.AnnotatedElement;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.NativeQuery;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaQueryConfiguration;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryProvider;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.ObjectUtils;

class NativeJpaQuery
extends AbstractStringBasedJpaQuery {
    @Nullable
    private final String sqlResultSetMapping;
    private final boolean queryForEntity;

    NativeJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, @Nullable String countQueryString, JpaQueryConfiguration queryConfiguration) {
        super(method, em, queryString, countQueryString, queryConfiguration);
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)method.getMethod());
        MergedAnnotation annotation = annotations.get(NativeQuery.class);
        this.sqlResultSetMapping = annotation.isPresent() ? annotation.getString("sqlResultSetMapping") : null;
        this.queryForEntity = this.getQueryMethod().isQueryForEntity();
    }

    public NativeJpaQuery(JpaQueryMethod method, EntityManager em, DeclaredQuery query, @Nullable DeclaredQuery countQuery, JpaQueryConfiguration queryConfiguration) {
        super(method, em, query, countQuery, queryConfiguration);
        MergedAnnotations annotations = MergedAnnotations.from((AnnotatedElement)method.getMethod());
        MergedAnnotation annotation = annotations.get(NativeQuery.class);
        this.sqlResultSetMapping = annotation.isPresent() ? annotation.getString("sqlResultSetMapping") : null;
        this.queryForEntity = this.getQueryMethod().isQueryForEntity();
    }

    @Override
    protected Query createJpaQuery(QueryProvider declaredQuery, Sort sort, @Nullable Pageable pageable, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        String query = this.potentiallyRewriteQuery(declaredQuery.getQueryString(), sort, pageable);
        if (!ObjectUtils.isEmpty((Object)this.sqlResultSetMapping)) {
            return em.createNativeQuery(query, this.sqlResultSetMapping);
        }
        Class<?> type = this.getTypeToQueryFor(returnedType);
        return type == null ? em.createNativeQuery(query) : em.createNativeQuery(query, type);
    }

    @Nullable
    private Class<?> getTypeToQueryFor(ReturnedType returnedType) {
        Class result;
        Class clazz = result = this.queryForEntity ? returnedType.getDomainType() : null;
        if (this.getQuery().hasConstructorExpression() || this.getQuery().isDefaultProjection()) {
            return result;
        }
        if (returnedType.isProjecting()) {
            if (returnedType.isInterfaceProjection()) {
                return Tuple.class;
            }
            return returnedType.getReturnedType();
        }
        return result;
    }
}

