/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.CriteriaQueryParameterBinder;
import org.springframework.data.jpa.repository.query.JpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeJpaQuery
extends AbstractJpaQuery {
    private final Class<?> domainClass;
    private final PartTree tree;
    private final Parameters parameters;
    private final QueryPreparer query;
    private final QueryPreparer countQuery;

    public PartTreeJpaQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        this.domainClass = method.getEntityInformation().getJavaType();
        this.tree = new PartTree(method.getName(), this.domainClass);
        this.parameters = method.getParameters();
        this.query = new QueryPreparer(this.parameters.potentiallySortsDynamically());
        this.countQuery = new CountQueryPreparer(this.parameters.potentiallySortsDynamically());
    }

    public Query createQuery(Object[] values) {
        return this.query.createQuery(values);
    }

    public Query createCountQuery(Object[] values) {
        return this.countQuery.createQuery(values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CountQueryPreparer
    extends QueryPreparer {
        public CountQueryPreparer(boolean recreateQueries) {
            super(recreateQueries);
        }

        @Override
        protected JpaQueryCreator createCreator() {
            return new JpaCountQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.domainClass, PartTreeJpaQuery.this.parameters, PartTreeJpaQuery.this.getEntityManager());
        }

        @Override
        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bind((Query)query);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryPreparer {
        private final CriteriaQuery<?> query;
        private final List<ParameterExpression<?>> expressions;

        public QueryPreparer(boolean recreateQueries) {
            JpaQueryCreator creator = this.createCreator();
            this.query = recreateQueries ? null : (CriteriaQuery)creator.createQuery();
            this.expressions = recreateQueries ? null : creator.getParameterExpressions();
        }

        public Query createQuery(Object[] values) {
            CriteriaQuery criteriaQuery = this.query;
            List<ParameterExpression<?>> expressions = this.expressions;
            if (this.query == null) {
                JpaQueryCreator creator = this.createCreator();
                criteriaQuery = (CriteriaQuery)creator.createQuery(this.getDynamicSort(values));
                expressions = creator.getParameterExpressions();
            }
            TypedQuery jpaQuery = PartTreeJpaQuery.this.getEntityManager().createQuery(criteriaQuery);
            return this.invokeBinding(this.getBinder(values, expressions), jpaQuery);
        }

        protected JpaQueryCreator createCreator() {
            return new JpaQueryCreator(PartTreeJpaQuery.this.tree, PartTreeJpaQuery.this.domainClass, PartTreeJpaQuery.this.parameters, PartTreeJpaQuery.this.getEntityManager());
        }

        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bindAndPrepare((Query)query);
        }

        private ParameterBinder getBinder(Object[] values, List<ParameterExpression<?>> expressions) {
            return new CriteriaQueryParameterBinder(PartTreeJpaQuery.this.parameters, values, expressions);
        }

        private Sort getDynamicSort(Object[] values) {
            return PartTreeJpaQuery.this.parameters.potentiallySortsDynamically() ? new ParametersParameterAccessor(PartTreeJpaQuery.this.parameters, values).getSort() : null;
        }
    }
}

