/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import org.springframework.data.repository.config.AutomaticRepositoryConfigInformation;
import org.springframework.data.repository.config.CommonRepositoryConfigInformation;
import org.springframework.data.repository.config.ManualRepositoryConfigInformation;
import org.springframework.data.repository.config.RepositoryConfig;
import org.springframework.data.repository.config.SingleRepositoryConfigInformation;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJpaRepositoryConfiguration
extends RepositoryConfig<JpaRepositoryConfiguration, SimpleJpaRepositoryConfiguration> {
    private static final String FACTORY_CLASS = "org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean";
    private static final String ENTITY_MANAGER_FACTORY_REF = "entity-manager-factory-ref";

    public SimpleJpaRepositoryConfiguration(Element repositoriesElement) {
        super(repositoriesElement, FACTORY_CLASS);
    }

    public JpaRepositoryConfiguration getAutoconfigRepositoryInformation(String interfaceName) {
        return new AutomaticJpaRepositoryConfigInformation(interfaceName, this);
    }

    public JpaRepositoryConfiguration createSingleRepositoryConfigInformationFor(Element element) {
        return new ManualJpaRepositoryConfigInformation(element, this);
    }

    public String getNamedQueriesLocation() {
        return "classpath*:META-INF/jpa-named-queries.properties";
    }

    public String getEntityManagerFactoryRef() {
        return this.getSource().getAttribute(ENTITY_MANAGER_FACTORY_REF);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface JpaRepositoryConfiguration
    extends SingleRepositoryConfigInformation<SimpleJpaRepositoryConfiguration> {
        public String getEntityManagerFactoryRef();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManualJpaRepositoryConfigInformation
    extends ManualRepositoryConfigInformation<SimpleJpaRepositoryConfiguration>
    implements JpaRepositoryConfiguration {
        public ManualJpaRepositoryConfigInformation(Element element, SimpleJpaRepositoryConfiguration parent) {
            super(element, (CommonRepositoryConfigInformation)parent);
        }

        @Override
        public String getEntityManagerFactoryRef() {
            return this.getAttribute(SimpleJpaRepositoryConfiguration.ENTITY_MANAGER_FACTORY_REF);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AutomaticJpaRepositoryConfigInformation
    extends AutomaticRepositoryConfigInformation<SimpleJpaRepositoryConfiguration>
    implements JpaRepositoryConfiguration {
        public AutomaticJpaRepositoryConfigInformation(String interfaceName, SimpleJpaRepositoryConfiguration parent) {
            super(interfaceName, (CommonRepositoryConfigInformation)parent);
        }

        @Override
        public String getEntityManagerFactoryRef() {
            return ((SimpleJpaRepositoryConfiguration)this.getParent()).getEntityManagerFactoryRef();
        }
    }
}

