/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.mvc.UriComponentsContributor;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class HateoasSortHandlerMethodArgumentResolver
extends SortHandlerMethodArgumentResolver
implements UriComponentsContributor {
    public TemplateVariables getSortTemplateVariables(MethodParameter parameter, UriComponents template) {
        boolean append;
        String sortParameter = this.getSortParameter(parameter);
        MultiValueMap queryParameters = template.getQueryParams();
        boolean bl = append = !queryParameters.isEmpty();
        if (queryParameters.containsKey((Object)sortParameter)) {
            return TemplateVariables.NONE;
        }
        String description = String.format("pagination.%s.description", sortParameter);
        TemplateVariable.VariableType type = append ? TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED : TemplateVariable.VariableType.REQUEST_PARAM;
        return new TemplateVariables(new TemplateVariable[]{new TemplateVariable(sortParameter, type, description)});
    }

    public void enhance(UriComponentsBuilder builder, MethodParameter parameter, Object value) {
        if (!(value instanceof Sort)) {
            return;
        }
        Sort sort = (Sort)value;
        String sortParameter = this.getSortParameter(parameter);
        if (this.legacyMode) {
            List<String> expressions = this.legacyFoldExpressions(sort);
            Assert.isTrue((expressions.size() == 2 ? 1 : 0) != 0, (String)String.format("Expected 2 sort expressions (fields, direction) but got %d!", expressions.size()));
            builder.replaceQueryParam(sortParameter, new Object[]{expressions.get(0)});
            builder.replaceQueryParam(this.getLegacyDirectionParameter(parameter), new Object[]{expressions.get(1)});
        } else {
            builder.replaceQueryParam(sortParameter, new Object[0]);
            for (String expression : this.foldIntoExpressions(sort)) {
                builder.queryParam(sortParameter, new Object[]{expression});
            }
        }
    }
}

