/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.repository.core.CrudInvoker;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.util.StringUtils;

public class DomainClassConverter<T extends ConversionService & ConverterRegistry>
implements ConditionalGenericConverter,
ApplicationContextAware {
    private final T conversionService;
    private Repositories repositories = Repositories.NONE;

    public DomainClassConverter(T conversionService) {
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null || !StringUtils.hasText((String)source.toString())) {
            return null;
        }
        Class domainType = targetType.getType();
        RepositoryInformation info = this.repositories.getRepositoryInformationFor(domainType);
        CrudInvoker invoker = this.repositories.getCrudInvoker(domainType);
        return invoker.invokeFindOne((Serializable)this.conversionService.convert(source, info.getIdType()));
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (!this.repositories.hasRepositoryFor(targetType.getType())) {
            return false;
        }
        return this.conversionService.canConvert(sourceType.getType(), this.repositories.getRepositoryInformationFor(targetType.getType()).getIdType());
    }

    public void setApplicationContext(ApplicationContext context) {
        this.repositories = new Repositories((ListableBeanFactory)context);
        ((ConverterRegistry)this.conversionService).addConverter((GenericConverter)this);
    }
}

