/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.init;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.core.io.Resource;
import org.springframework.data.repository.init.ResourceReader;
import org.springframework.util.ClassUtils;

public class JacksonResourceReader
implements ResourceReader {
    private static final String DEFAULT_TYPE_KEY = "_class";
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private final ObjectMapper mapper;
    private String typeKey = "_class";

    public JacksonResourceReader() {
        this(DEFAULT_MAPPER);
    }

    public JacksonResourceReader(ObjectMapper mapper) {
        this.mapper = mapper == null ? DEFAULT_MAPPER : mapper;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    @Override
    public Object readFrom(Resource resource, ClassLoader classLoader) throws Exception {
        InputStream stream = resource.getInputStream();
        JsonNode node = this.mapper.reader(JsonNode.class).readTree(stream);
        if (node.isArray()) {
            Iterator elements = node.getElements();
            ArrayList<Object> result = new ArrayList<Object>();
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                result.add(this.readSingle(element, classLoader));
            }
            return result;
        }
        return this.readSingle(node, classLoader);
    }

    private Object readSingle(JsonNode node, ClassLoader classLoader) throws IOException {
        JsonNode typeNode = node.findValue(this.typeKey);
        String typeName = typeNode == null ? null : typeNode.asText();
        Class type = ClassUtils.resolveClassName((String)typeName, (ClassLoader)classLoader);
        return this.mapper.reader(type).readValue(node);
    }

    static {
        DEFAULT_MAPPER.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

