/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.ReflectionEntityInstantiator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityInstantiators {
    private final EntityInstantiator fallback;
    private final Map<Class<?>, EntityInstantiator> customInstantiators;

    public EntityInstantiators() {
        this(Collections.emptyMap());
    }

    public EntityInstantiators(EntityInstantiator fallback) {
        this(fallback, Collections.emptyMap());
    }

    public EntityInstantiators(Map<Class<?>, EntityInstantiator> customInstantiators) {
        this(ReflectionEntityInstantiator.INSTANCE, customInstantiators);
    }

    public EntityInstantiators(EntityInstantiator defaultInstantiator, Map<Class<?>, EntityInstantiator> customInstantiators) {
        Assert.notNull((Object)defaultInstantiator);
        Assert.notNull(customInstantiators);
        this.fallback = defaultInstantiator;
        this.customInstantiators = customInstantiators;
    }

    public EntityInstantiator getInstantiatorFor(PersistentEntity<?, ?> entity) {
        Assert.notNull(entity);
        Class<?> type = entity.getType();
        if (!this.customInstantiators.containsKey(type)) {
            return this.fallback;
        }
        EntityInstantiator instantiator = this.customInstantiators.get(entity.getType());
        return instantiator == null ? this.fallback : instantiator;
    }
}

