/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.springframework.beans.BeanUtils;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.GenericArrayTypeInformation;
import org.springframework.data.util.ParameterizedTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.data.util.TypeVariableTypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TypeDiscoverer<S>
implements TypeInformation<S> {
    private static final Iterable<Class<?>> MAP_TYPES;
    private final Type type;
    private final Map<TypeVariable<?>, Type> typeVariableMap;
    private final Map<String, ValueHolder> fieldTypes = new ConcurrentHashMap<String, ValueHolder>();
    private final int hashCode;
    private boolean componentTypeResolved = false;
    private TypeInformation<?> componentType;
    private boolean valueTypeResolved = false;
    private TypeInformation<?> valueType;
    private Class<S> resolvedType;

    protected TypeDiscoverer(Type type, Map<TypeVariable<?>, Type> typeVariableMap) {
        Assert.notNull((Object)type, (String)"Type must not be null!");
        Assert.notNull(typeVariableMap, (String)"TypeVariableMap must not be null!");
        this.type = type;
        this.typeVariableMap = typeVariableMap;
        this.hashCode = 17 + 31 * type.hashCode() + 31 * typeVariableMap.hashCode();
    }

    protected Map<TypeVariable<?>, Type> getTypeVariableMap() {
        return this.typeVariableMap;
    }

    protected TypeInformation<?> createInfo(Type fieldType) {
        if (fieldType.equals(this.type)) {
            return this;
        }
        if (fieldType instanceof Class) {
            return ClassTypeInformation.from((Class)fieldType);
        }
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            return new ParameterizedTypeInformation(parameterizedType, this);
        }
        if (fieldType instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)fieldType;
            return new TypeVariableTypeInformation(variable, this);
        }
        if (fieldType instanceof GenericArrayType) {
            return new GenericArrayTypeInformation((GenericArrayType)fieldType, this);
        }
        if (fieldType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)fieldType;
            Type[] bounds = wildcardType.getLowerBounds();
            if (bounds.length > 0) {
                return this.createInfo(bounds[0]);
            }
            bounds = wildcardType.getUpperBounds();
            if (bounds.length > 0) {
                return this.createInfo(bounds[0]);
            }
        }
        throw new IllegalArgumentException();
    }

    protected Class<S> resolveType(Type type) {
        HashMap map = new HashMap();
        map.putAll(this.getTypeVariableMap());
        return GenericTypeResolver.resolveType((Type)type, map);
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Constructor<?> constructor) {
        Assert.notNull(constructor, (String)"Constructor must not be null!");
        Type[] types = constructor.getGenericParameterTypes();
        ArrayList result = new ArrayList(types.length);
        for (Type parameterType : types) {
            result.add(this.createInfo(parameterType));
        }
        return result;
    }

    @Override
    public TypeInformation<?> getProperty(String fieldname) {
        int separatorIndex = fieldname.indexOf(46);
        if (separatorIndex == -1) {
            if (this.fieldTypes.containsKey(fieldname)) {
                return this.fieldTypes.get(fieldname).getType();
            }
            TypeInformation<?> propertyInformation = this.getPropertyInformation(fieldname);
            this.fieldTypes.put(fieldname, ValueHolder.of(propertyInformation));
            return propertyInformation;
        }
        String head = fieldname.substring(0, separatorIndex);
        TypeInformation<?> info = this.getProperty(head);
        return info == null ? null : info.getProperty(fieldname.substring(separatorIndex + 1));
    }

    private TypeInformation<?> getPropertyInformation(String fieldname) {
        Class<S> rawType = this.getType();
        Field field = ReflectionUtils.findField(rawType, (String)fieldname);
        if (field != null) {
            return this.createInfo(field.getGenericType());
        }
        PropertyDescriptor descriptor = TypeDiscoverer.findPropertyDescriptor(rawType, fieldname);
        return descriptor == null ? null : this.createInfo(TypeDiscoverer.getGenericType(descriptor));
    }

    private static PropertyDescriptor findPropertyDescriptor(Class<?> type, String fieldname) {
        PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(type, (String)fieldname);
        if (descriptor != null) {
            return descriptor;
        }
        ArrayList superTypes = new ArrayList();
        superTypes.addAll(Arrays.asList(type.getInterfaces()));
        superTypes.add(type.getSuperclass());
        for (Class<?> interfaceType : type.getInterfaces()) {
            descriptor = TypeDiscoverer.findPropertyDescriptor(interfaceType, fieldname);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    private static Type getGenericType(PropertyDescriptor descriptor) {
        Method method = descriptor.getReadMethod();
        if (method != null) {
            return method.getGenericReturnType();
        }
        method = descriptor.getWriteMethod();
        if (method == null) {
            return null;
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        return parameterTypes.length == 0 ? null : parameterTypes[0];
    }

    @Override
    public Class<S> getType() {
        if (this.resolvedType == null) {
            this.resolvedType = this.resolveType(this.type);
        }
        return this.resolvedType;
    }

    @Override
    public ClassTypeInformation<?> getRawTypeInformation() {
        return ClassTypeInformation.from(this.getType()).getRawTypeInformation();
    }

    @Override
    public TypeInformation<?> getActualType() {
        if (this.isMap()) {
            return this.getMapValueType();
        }
        if (this.isCollectionLike()) {
            return this.getComponentType();
        }
        return this;
    }

    @Override
    public boolean isMap() {
        for (Class<S> clazz : MAP_TYPES) {
            if (!clazz.isAssignableFrom(this.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public TypeInformation<?> getMapValueType() {
        if (!this.valueTypeResolved) {
            this.valueType = this.doGetMapValueType();
            this.valueTypeResolved = true;
        }
        return this.valueType;
    }

    protected TypeInformation<?> doGetMapValueType() {
        if (this.isMap()) {
            return this.getTypeArgument(this.getBaseType(MAP_TYPES), 1);
        }
        List<TypeInformation<?>> arguments = this.getTypeArguments();
        if (arguments.size() > 1) {
            return arguments.get(1);
        }
        return null;
    }

    @Override
    public boolean isCollectionLike() {
        Class<S> rawType = this.getType();
        if (rawType.isArray() || Iterable.class.equals(rawType)) {
            return true;
        }
        return Collection.class.isAssignableFrom(rawType);
    }

    @Override
    public final TypeInformation<?> getComponentType() {
        if (!this.componentTypeResolved) {
            this.componentType = this.doGetComponentType();
            this.componentTypeResolved = true;
        }
        return this.componentType;
    }

    protected TypeInformation<?> doGetComponentType() {
        Class<S> rawType = this.getType();
        if (rawType.isArray()) {
            return this.createInfo(rawType.getComponentType());
        }
        if (this.isMap()) {
            return this.getTypeArgument(this.getBaseType(MAP_TYPES), 0);
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            return this.getTypeArgument(Iterable.class, 0);
        }
        List<TypeInformation<?>> arguments = this.getTypeArguments();
        if (arguments.size() > 0) {
            return arguments.get(0);
        }
        return null;
    }

    @Override
    public TypeInformation<?> getReturnType(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return this.createInfo(method.getGenericReturnType());
    }

    @Override
    public List<TypeInformation<?>> getParameterTypes(Method method) {
        Assert.notNull((Object)method, (String)"Method most not be null!");
        Type[] types = method.getGenericParameterTypes();
        ArrayList result = new ArrayList(types.length);
        for (Type parameterType : types) {
            result.add(this.createInfo(parameterType));
        }
        return result;
    }

    @Override
    public TypeInformation<?> getSuperTypeInformation(Class<?> superType) {
        Class<S> rawType = this.getType();
        if (!superType.isAssignableFrom(rawType)) {
            return null;
        }
        if (this.getType().equals(superType)) {
            return this;
        }
        ArrayList<Type> candidates = new ArrayList<Type>();
        Type genericSuperclass = rawType.getGenericSuperclass();
        if (genericSuperclass != null) {
            candidates.add(genericSuperclass);
        }
        candidates.addAll(Arrays.asList(rawType.getGenericInterfaces()));
        for (Type candidate : candidates) {
            TypeInformation<S> candidateInfo = this.createInfo(candidate);
            if (superType.equals(candidateInfo.getType())) {
                return candidateInfo;
            }
            TypeInformation<?> nestedSuperType = candidateInfo.getSuperTypeInformation(superType);
            if (nestedSuperType == null) continue;
            return nestedSuperType;
        }
        return null;
    }

    @Override
    public List<TypeInformation<?>> getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        return target.getSuperTypeInformation(this.getType()).equals(this);
    }

    @Override
    public TypeInformation<?> specialize(ClassTypeInformation<?> type) {
        Assert.isTrue((boolean)this.getType().isAssignableFrom(type.getType()), (String)String.format("%s must be assignable from %s", this.getType(), type.getType()));
        List<TypeInformation<?>> arguments = this.getTypeArguments();
        return arguments.isEmpty() ? type : this.createInfo(new SyntheticParamterizedType(type, arguments));
    }

    private TypeInformation<?> getTypeArgument(Class<?> bound, int index) {
        Class[] arguments = GenericTypeResolver.resolveTypeArguments(this.getType(), bound);
        if (arguments == null) {
            return this.getSuperTypeInformation(bound) instanceof ParameterizedTypeInformation ? ClassTypeInformation.OBJECT : null;
        }
        return this.createInfo(arguments[index]);
    }

    private Class<?> getBaseType(Iterable<Class<?>> candidates) {
        for (Class<S> clazz : candidates) {
            if (!clazz.isAssignableFrom(this.getType())) continue;
            return clazz;
        }
        throw new IllegalArgumentException(String.format("Type %s not contained in candidates %s!", this.getType(), candidates));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        TypeDiscoverer that = (TypeDiscoverer)obj;
        return this.type.equals(that.type) && this.typeVariableMap.equals(that.typeVariableMap);
    }

    public int hashCode() {
        return this.hashCode;
    }

    static {
        ClassLoader classLoader = TypeDiscoverer.class.getClassLoader();
        HashSet<Class> mapTypes = new HashSet<Class>();
        mapTypes.add(Map.class);
        try {
            mapTypes.add(ClassUtils.forName((String)"javaslang.collection.Map", (ClassLoader)classLoader));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        MAP_TYPES = Collections.unmodifiableSet(mapTypes);
    }

    private static final class ValueHolder {
        static ValueHolder NULL_HOLDER = new ValueHolder(null);
        private final TypeInformation<?> type;

        public static ValueHolder of(TypeInformation<?> type) {
            return null == type ? NULL_HOLDER : new ValueHolder(type);
        }

        public TypeInformation<?> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueHolder)) {
                return false;
            }
            ValueHolder other = (ValueHolder)o;
            TypeInformation<?> this$type = this.getType();
            TypeInformation<?> other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeInformation<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "TypeDiscoverer.ValueHolder(type=" + this.getType() + ")";
        }

        private ValueHolder(TypeInformation<?> type) {
            this.type = type;
        }
    }

    private static class SyntheticParamterizedType
    implements ParameterizedType {
        @NonNull
        private final ClassTypeInformation<?> typeInformation;
        @NonNull
        private final List<TypeInformation<?>> typeParameters;

        @Override
        public Type getRawType() {
            return this.typeInformation.getType();
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type[] getActualTypeArguments() {
            Type[] result = new Type[this.typeParameters.size()];
            for (int i = 0; i < this.typeParameters.size(); ++i) {
                result[i] = this.typeParameters.get(i).getType();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SyntheticParamterizedType)) {
                return false;
            }
            SyntheticParamterizedType other = (SyntheticParamterizedType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClassTypeInformation<?> this$typeInformation = this.typeInformation;
            ClassTypeInformation<?> other$typeInformation = other.typeInformation;
            if (this$typeInformation == null ? other$typeInformation != null : !((Object)this$typeInformation).equals(other$typeInformation)) {
                return false;
            }
            List<TypeInformation<?>> this$typeParameters = this.typeParameters;
            List<TypeInformation<?>> other$typeParameters = other.typeParameters;
            return !(this$typeParameters == null ? other$typeParameters != null : !((Object)this$typeParameters).equals(other$typeParameters));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SyntheticParamterizedType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClassTypeInformation<?> $typeInformation = this.typeInformation;
            result = result * 59 + ($typeInformation == null ? 43 : ((Object)$typeInformation).hashCode());
            List<TypeInformation<?>> $typeParameters = this.typeParameters;
            result = result * 59 + ($typeParameters == null ? 43 : ((Object)$typeParameters).hashCode());
            return result;
        }

        public SyntheticParamterizedType(@NonNull ClassTypeInformation<?> typeInformation, @NonNull List<TypeInformation<?>> typeParameters) {
            if (typeInformation == null) {
                throw new IllegalArgumentException("typeInformation is null");
            }
            if (typeParameters == null) {
                throw new IllegalArgumentException("typeParameters is null");
            }
            this.typeInformation = typeInformation;
            this.typeParameters = typeParameters;
        }
    }
}

