/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import org.springframework.cloud.contract.verifier.builder.BaseClassProvider;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ClassMetaData;
import org.springframework.cloud.contract.verifier.builder.DefaultClassMetadata;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.config.TestFramework;
import org.springframework.util.StringUtils;

class JavaClassMetaData
implements ClassMetaData,
DefaultClassMetadata {
    private final BlockBuilder blockBuilder;
    private final BaseClassProvider baseClassProvider = new BaseClassProvider();
    private final GeneratedClassMetaData generatedClassMetaData;

    JavaClassMetaData(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public ClassMetaData modifier() {
        this.blockBuilder.append("public");
        return this;
    }

    @Override
    public ClassMetaData suffix() {
        String suffix;
        String string = suffix = StringUtils.hasText((String)this.generatedClassMetaData.configProperties.getNameSuffixForTests()) ? this.generatedClassMetaData.configProperties.getNameSuffixForTests() : "Test";
        if (!this.blockBuilder.endsWith(suffix)) {
            this.blockBuilder.addAtTheEnd(suffix);
        }
        return this;
    }

    @Override
    public ClassMetaData setupLineEnding() {
        this.blockBuilder.setupLineEnding(";");
        return this;
    }

    @Override
    public ClassMetaData setupLabelPrefix() {
        this.blockBuilder.setupLabelPrefix("// ");
        return this;
    }

    @Override
    public GeneratedClassMetaData generatedClassMetaData() {
        return this.generatedClassMetaData;
    }

    @Override
    public BaseClassProvider baseClassProvider() {
        return this.baseClassProvider;
    }

    @Override
    public BlockBuilder blockBuilder() {
        return this.blockBuilder;
    }

    @Override
    public ClassMetaData parentClass() {
        String baseClass = this.fqnBaseClass();
        if (StringUtils.hasText((String)baseClass)) {
            int lastIndexOf = baseClass.lastIndexOf(".");
            if (lastIndexOf > 0) {
                baseClass = baseClass.substring(lastIndexOf + 1);
            }
            this.blockBuilder().append("extends ").append(baseClass).append(" ");
        }
        return this;
    }

    @Override
    public boolean accept() {
        return this.generatedClassMetaData.configProperties.getTestFramework() == TestFramework.JUNIT || this.generatedClassMetaData.configProperties.getTestFramework() == TestFramework.JUNIT5 || this.generatedClassMetaData.configProperties.getTestFramework() == TestFramework.TESTNG;
    }
}

