/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.reactive;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.io.ClientConnector;
import org.springframework.boot.http.client.JettyHttpClientBuilder;
import org.springframework.boot.http.client.reactive.AbstractClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.http.client.reactive.JettyClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class JettyClientHttpConnectorBuilder
extends AbstractClientHttpConnectorBuilder<JettyClientHttpConnector> {
    private final JettyHttpClientBuilder httpClientBuilder;

    JettyClientHttpConnectorBuilder() {
        this(null, new JettyHttpClientBuilder());
    }

    private JettyClientHttpConnectorBuilder(List<Consumer<JettyClientHttpConnector>> customizers, JettyHttpClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public JettyClientHttpConnectorBuilder withCustomizer(Consumer<JettyClientHttpConnector> customizer) {
        return new JettyClientHttpConnectorBuilder(this.mergedCustomizers(customizer), this.httpClientBuilder);
    }

    public JettyClientHttpConnectorBuilder withCustomizers(Collection<Consumer<JettyClientHttpConnector>> customizers) {
        return new JettyClientHttpConnectorBuilder(this.mergedCustomizers(customizers), this.httpClientBuilder);
    }

    public JettyClientHttpConnectorBuilder withHttpClientCustomizer(Consumer<HttpClient> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, (String)"'httpClientCustomizer' must not be null");
        return new JettyClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withCustomizer(httpClientCustomizer));
    }

    public JettyClientHttpConnectorBuilder withHttpClientTransportCustomizer(Consumer<HttpClientTransport> httpClientTransportCustomizer) {
        Assert.notNull(httpClientTransportCustomizer, (String)"'httpClientTransportCustomizer' must not be null");
        return new JettyClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withHttpClientTransportCustomizer(httpClientTransportCustomizer));
    }

    public JettyClientHttpConnectorBuilder withClientConnectorCustomizerCustomizer(Consumer<ClientConnector> clientConnectorCustomizerCustomizer) {
        Assert.notNull(clientConnectorCustomizerCustomizer, (String)"'clientConnectorCustomizerCustomizer' must not be null");
        return new JettyClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withClientConnectorCustomizerCustomizer(clientConnectorCustomizerCustomizer));
    }

    @Override
    protected JettyClientHttpConnector createClientHttpConnector(ClientHttpConnectorSettings settings) {
        HttpClient httpClient = this.httpClientBuilder.build(this.asHttpClientSettings(settings));
        return new JettyClientHttpConnector(httpClient);
    }

    static class Classes {
        static final String HTTP_CLIENT = "org.eclipse.jetty.client.HttpClient";
        static final String REACTIVE_REQUEST = "org.eclipse.jetty.reactive.client.ReactiveRequest";

        Classes() {
        }

        static boolean present(ClassLoader classLoader) {
            return ClassUtils.isPresent((String)HTTP_CLIENT, (ClassLoader)classLoader) && ClassUtils.isPresent((String)REACTIVE_REQUEST, (ClassLoader)classLoader);
        }
    }
}

