/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.maven.DependencyCollector;
import org.sonarsource.scanner.maven.ExtensionsFactory;
import org.sonarsource.scanner.maven.bootstrap.LogHandler;
import org.sonarsource.scanner.maven.bootstrap.MavenProjectConverter;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;
import org.sonarsource.scanner.maven.bootstrap.ScannerBootstrapper;
import org.sonarsource.scanner.maven.bootstrap.ScannerFactory;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Mojo(name="sonar", requiresDependencyResolution=ResolutionScope.TEST, aggregator=true)
public class SonarQubeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="sonar.skip", defaultValue="false", alias="sonar.skip")
    private boolean skip;
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactCollector artifactCollector;
    @Component
    private DependencyTreeBuilder dependencyTreeBuilder;
    @Component
    private MavenProjectBuilder projectBuilder;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;
    @Component
    private RuntimeInformation runtimeInformation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"sonar.skip = true: Skipping analysis");
            return;
        }
        try {
            ExtensionsFactory extensionsFactory = new ExtensionsFactory(this.getLog(), this.session, this.lifecycleExecutor, this.artifactFactory, this.localRepository, this.artifactMetadataSource, this.artifactCollector, this.dependencyTreeBuilder, this.projectBuilder);
            DependencyCollector dependencyCollector = new DependencyCollector(this.dependencyTreeBuilder, this.localRepository);
            MavenProjectConverter mavenProjectConverter = new MavenProjectConverter(this.getLog(), dependencyCollector);
            LogHandler logHandler = new LogHandler(this.getLog());
            PropertyDecryptor propertyDecryptor = new PropertyDecryptor(this.getLog(), this.securityDispatcher);
            ScannerFactory runnerFactory = new ScannerFactory(logHandler, this.getLog().isDebugEnabled(), this.runtimeInformation, this.session, propertyDecryptor);
            EmbeddedScanner runner = runnerFactory.create();
            new ScannerBootstrapper(this.getLog(), this.session, runner, mavenProjectConverter, extensionsFactory, propertyDecryptor).execute();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute SonarQube analysis", (Exception)e);
        }
    }

    @VisibleForTesting
    void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    @VisibleForTesting
    MavenSession getSession() {
        return this.session;
    }
}

