/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter;

import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ContextualConverter;

public class ComposedContextualConverter<I, J, O>
implements ContextualConverter<I, O> {
    public final ContextualConverter<? super I, ? extends J> c1;
    public final ContextualConverter<? super J, ? extends O> c2;

    public ComposedContextualConverter(ContextualConverter<? super I, ? extends J> c1, ContextualConverter<? super J, ? extends O> c2) {
        if (c1 == null || c2 == null) {
            throw new NullPointerException();
        }
        this.c1 = c1;
        this.c2 = c2;
    }

    @Override
    public O convert(I in, Context context) throws Exception {
        return this.c2.convert(this.c1.convert(in, context), context);
    }

    public String toString() {
        return "ComposedConverter{c1=" + String.valueOf(this.c1) + ", c2=" + String.valueOf(this.c2) + "}";
    }

    public int depth() {
        int i = 2;
        if (this.c1 instanceof ComposedContextualConverter) {
            i += ((ComposedContextualConverter)this.c1).depth();
        }
        if (this.c2 instanceof ComposedContextualConverter) {
            i += ((ComposedContextualConverter)this.c2).depth();
        }
        return i;
    }
}

