/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.sharengo.wikitty.generator.EugengoUtils;
import org.sharengo.wikitty.generator.WikengoCommonGenerator;

public class BusinessEntityGenerator
extends WikengoCommonGenerator {
    private static final Log log = LogFactory.getLog(BusinessEntityGenerator.class);
    protected static Pattern extractTypeOnCollection = Pattern.compile("\\w*<(\\w+)>");
    protected String EXT_NAME;
    private static Set<String> commonNumerics = new HashSet<String>();
    private static Set<String> commonStrings;
    private static Set<String> commonTypes;

    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info((Object)("Filename for " + clazz.getName() + " is " + fqn.replace('.', File.separatorChar) + ".java"));
        return fqn.replace('.', File.separatorChar) + "Impl.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)clazz)) {
            log.info((Object)(clazz.getName() + " is not a business entity"));
            return;
        }
        log.info((Object)("Generate Business entity " + clazz.getName() + "... "));
        this.generateCopyright(output);
        this.EXT_NAME = "EXT_" + clazz.getName().toUpperCase();
        String packageName = clazz.getPackageName();
        String name = clazz.getName() + "Impl";
        output.write("package " + packageName + ";\n");
        output.write("\n");
        output.write("");
        ObjectModelClass superClass = this.findSuperClass(clazz);
        this.clearImports();
        this.addImport(clazz);
        this.addImport(superClass);
        this.addImport("org.sharengo.wikitty.WikittyUtil");
        this.addImport("org.sharengo.wikitty.Wikitty");
        this.addImport("org.sharengo.wikitty.BusinessEntityWikitty");
        this.addImport("org.sharengo.wikitty.WikittyExtension");
        this.addImport(Collection.class);
        this.addImport(Collections.class);
        this.addImport(List.class);
        this.addImport(ArrayList.class);
        String parentImpl = null;
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.addImport(parent);
            parentImpl = parent.getQualifiedName() + "Impl";
            this.addImport(parentImpl);
        }
        this.lookForAttributeImports(clazz);
        this.generateImports(output, packageName);
        this.generateClazzDocumentation(output, (ObjectModelClassifier)clazz, new String[0]);
        String extendsString = " extends " + (parentImpl != null ? parentImpl : this.getType("org.sharengo.wikitty.BusinessEntityWikitty"));
        String abstractString = "";
        if (clazz.isAbstract()) {
            abstractString = abstractString + "abstract ";
        }
        String implementsString = "implements " + this.getType(clazz.getQualifiedName());
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            implementsString = implementsString + ", " + this.getType(parent.getQualifiedName());
        }
        output.write("public " + abstractString + "class " + name + "" + extendsString + " " + implementsString + " {\n");
        output.write("\n");
        output.write("");
        String svUID = GeneratorUtil.computeSerialVersionUID((ObjectModelClass)clazz);
        output.write("    private static final long serialVersionUID = " + svUID + ";\n");
        output.write("\n");
        output.write("");
        this.generateWikittyExtension(output, clazz);
        this.generateStaticAttributes(output, clazz);
        output.write("\n");
        output.write("\tpublic " + name + "() {\n");
        output.write("\t\tsuper();\n");
        output.write("\t}\n");
        output.write("\n");
        output.write("    public " + name + "(BusinessEntityWikitty wi) {\n");
        output.write("\t\tsuper(wi.getWikitty());\n");
        output.write("\t}\n");
        output.write("\n");
        output.write(" \tpublic " + name + "(Wikitty wi) {\n");
        output.write("\t\tsuper(wi);\n");
        output.write("\t}\n");
        output.write("\n");
        output.write("");
        this.generateAttributeAccessMethod(output, clazz);
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.generateParentMethod(output, parent);
        }
        output.write("    @Override\n");
        output.write("    public Collection<WikittyExtension> getStaticExtensions() {\n");
        output.write("        return extensions;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("\n");
        output.write("} //" + name + "\n");
        output.write("");
    }

    public void generateAttributeAccessMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            if (attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1) {
                this.generateCollectionAttributeAccessors(output, attr);
                continue;
            }
            this.generateWikittyAttributeAccessors(output, attr);
        }
    }

    private void generateWikittyExtension(Writer output, ObjectModelClass clazz) throws IOException {
        String version = clazz.getTagValue("version");
        if (version == null) {
            version = "1.0";
        }
        String requires = null;
        String separator = "";
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            String parentExtName = "EXT_" + parent.getName().toUpperCase();
            if (requires == null) {
                requires = "";
            }
            requires = requires + separator + parent.getName() + "." + parentExtName;
            separator = " + \",\" /* FIXME Multiples extentions are not yet supported */ + ";
        }
        output.write("    static final protected List<WikittyExtension> extensions;\n");
        output.write("    static final public WikittyExtension extension" + clazz.getName() + " =\n");
        output.write("        new WikittyExtension(" + this.EXT_NAME + ", \"" + version + "\", " + requires + ",\n");
        output.write("\t\t    WikittyUtil.buildFieldMapExtension(");
        separator = "";
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() || attr.isStatic() || attr.getStereotypes() != null && !attr.getStereotypes().isEmpty()) continue;
            output.write("" + separator + "\n");
            output.write("\t\t\t\t");
            this.generateAttribute(output, attr);
            separator = ",";
        }
        output.write("));\n");
        output.write("    static {\n");
        output.write("        ArrayList<WikittyExtension> exts = new ArrayList<WikittyExtension>();\n");
        output.write("");
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            output.write("\n");
            output.write("        exts.addAll(" + parent.getName() + "Impl.extensions);\n");
            output.write("");
        }
        output.write("\n");
        output.write("        // EC-20100420 add current extension after parent ones\n");
        output.write("        // if current is loaded before required extension\n");
        output.write("        // load failed because required extension is missing\n");
        output.write("        exts.add(extension" + clazz.getName() + ");\n");
        output.write("\n");
        output.write("        extensions = Collections.unmodifiableList(exts);\n");
        output.write("    }\n");
        output.write("");
    }

    private void generateAttribute(Writer output, ObjectModelAttribute attr) throws IOException {
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType);
        String attrName = attr.getName();
        String card = "";
        if (attrType.contains("Collection") || attrType.contains("List") || attrType.contains("Set")) {
            card = "[0-*]";
            Matcher match = extractTypeOnCollection.matcher(attrType);
            if (match.matches()) {
                attrType = match.group(1);
            }
        }
        if (!commonTypes.contains(attrType)) {
            attrType = "Wikitty";
        } else if (commonNumerics.contains(attrType)) {
            attrType = "Numeric";
        } else if (commonStrings.contains(attrType)) {
            attrType = "String";
        }
        int maxMultiplicity = attr.getMaxMultiplicity();
        if (maxMultiplicity != 0 && maxMultiplicity != 1) {
            card = "[" + attr.getMinMultiplicity() + "-";
            card = maxMultiplicity == -1 ? card + "*]" : card + maxMultiplicity + "]";
        }
        String unique = attr.isUnique() ? " unique" : "";
        String tagValues = "";
        if ("designation".equals(attr.getName())) {
            System.out.println("+++ DEBUG +++ " + attr.getName() + " " + attr.getTagValues());
        }
        for (String tag : attr.getTagValues().keySet()) {
            String value = attr.getTagValue(tag);
            tagValues = tagValues + " " + tag + "=" + value;
        }
        output.write("\"" + attrType + " " + attrName + "" + card + "" + unique + "" + tagValues + "\"");
    }

    private void generateParentMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (!EugengoUtils.isBusinessEntity((ObjectModelClassifier)parent)) continue;
            this.generateParentMethod(output, parent);
        }
        this.generateAttributeAccessMethod(output, clazz);
    }

    protected void generateWikittyAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        this.EXT_NAME = "EXT_" + attr.getDeclaringElement().getName().toUpperCase();
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String methodAccessName = this.getFieldAccessMethodName(attr);
        String attrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)attrName);
        output.write("\n");
        output.write("    public void set" + attrNameCapitalized + "(" + attrType + " " + attrName + ") {\n");
        output.write("        getWikitty().setField(" + this.EXT_NAME + ", \"" + attrName + "\", " + attrName + ");\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public " + attrType + " get" + attrNameCapitalized + "() {\n");
        output.write("        " + attrType + " result = getWikitty().getFieldAs" + methodAccessName + "(" + this.EXT_NAME + ", \"" + attrName + "\");\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    protected String getFieldAccessMethodName(ObjectModelAttribute attr) {
        boolean isCollection;
        String result = this.computeType((ObjectModelParameter)attr);
        result = this.getType(result, true);
        boolean bl = isCollection = attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1;
        if (isCollection) {
            result = attr.isUnique() ? "Set" : "List";
        } else if ("java.util.Date".equals(result) || "Date".equals(result)) {
            result = "Date";
        } else if (this.getModel().hasClass(result)) {
            ObjectModelClass fieldClass = this.getModel().getClass(result);
            if (EugengoUtils.isBusinessEntity((ObjectModelClassifier)fieldClass)) {
                result = "Wikitty";
            }
        } else if (null != this.getModel().getEnumeration(result)) {
            result = "String";
        }
        result = EugengoUtils.toUpperCaseFirstLetter((String)result);
        return result;
    }

    protected void generateCollectionAttributeAccessors(Writer output, ObjectModelAttribute attr) throws IOException {
        this.EXT_NAME = "EXT_" + attr.getDeclaringElement().getName().toUpperCase();
        String attrType = this.computeType((ObjectModelParameter)attr);
        if (!EugengoUtils.notEmpty((String)attrType)) {
            return;
        }
        attrType = this.getType(attrType, true);
        String elementType = this.getType(attr.getType(), true);
        String methodAccessName = this.getFieldAccessMethodName(attr);
        String attrName = attr.getName();
        String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter((String)attrName);
        output.write("    public " + attrType + " get" + attrNameCapitalized + "() {\n");
        output.write("        " + attrType + " result = getWikitty().getFieldAs" + methodAccessName + "(" + this.EXT_NAME + ", \"" + attrName + "\", " + this.getClassAndGeneric(attrType)[1] + ".class);\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void add" + attrNameCapitalized + "(" + elementType + " element) {\n");
        output.write("        getWikitty().addToField(" + this.EXT_NAME + ", \"" + attrName + "\", element);\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    public void remove" + attrNameCapitalized + "(" + elementType + " element) {\n");
        output.write("        getWikitty().removeFromField(" + this.EXT_NAME + ", \"" + attrName + "\", element);\n");
        output.write("    }\n");
        output.write("    \n");
        output.write("    public void clear" + attrNameCapitalized + "() {\n");
        output.write("        getWikitty().clearField(" + this.EXT_NAME + ", \"" + attrName + "\");\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
    }

    static {
        commonNumerics.add("byte");
        commonNumerics.add("Byte");
        commonNumerics.add("short");
        commonNumerics.add("Short");
        commonNumerics.add("int");
        commonNumerics.add("Integer");
        commonNumerics.add("long");
        commonNumerics.add("Long");
        commonNumerics.add("float");
        commonNumerics.add("Float");
        commonNumerics.add("double");
        commonNumerics.add("Double");
        commonStrings = new HashSet<String>();
        commonStrings.add("char");
        commonStrings.add("Char");
        commonStrings.add("String");
        commonTypes = new HashSet<String>();
        commonTypes.addAll(commonNumerics);
        commonTypes.addAll(commonStrings);
        commonTypes.add("boolean");
        commonTypes.add("Boolean");
        commonTypes.add("Date");
    }
}

