/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.preload.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v141.preload.model.PreloadPipelineId;
import org.openqa.selenium.devtools.v141.preload.model.PreloadingAttemptKey;
import org.openqa.selenium.devtools.v141.preload.model.PreloadingStatus;
import org.openqa.selenium.devtools.v141.preload.model.PrerenderFinalStatus;
import org.openqa.selenium.devtools.v141.preload.model.PrerenderMismatchedHeaders;
import org.openqa.selenium.json.JsonInput;

public class PrerenderStatusUpdated {
    private final PreloadingAttemptKey key;
    private final PreloadPipelineId pipelineId;
    private final PreloadingStatus status;
    private final Optional<PrerenderFinalStatus> prerenderStatus;
    private final Optional<String> disallowedMojoInterface;
    private final Optional<List<PrerenderMismatchedHeaders>> mismatchedHeaders;

    public PrerenderStatusUpdated(PreloadingAttemptKey key, PreloadPipelineId pipelineId, PreloadingStatus status, Optional<PrerenderFinalStatus> prerenderStatus, Optional<String> disallowedMojoInterface, Optional<List<PrerenderMismatchedHeaders>> mismatchedHeaders) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.pipelineId = Objects.requireNonNull(pipelineId, "pipelineId is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.prerenderStatus = prerenderStatus;
        this.disallowedMojoInterface = disallowedMojoInterface;
        this.mismatchedHeaders = mismatchedHeaders;
    }

    public PreloadingAttemptKey getKey() {
        return this.key;
    }

    public PreloadPipelineId getPipelineId() {
        return this.pipelineId;
    }

    public PreloadingStatus getStatus() {
        return this.status;
    }

    public Optional<PrerenderFinalStatus> getPrerenderStatus() {
        return this.prerenderStatus;
    }

    public Optional<String> getDisallowedMojoInterface() {
        return this.disallowedMojoInterface;
    }

    public Optional<List<PrerenderMismatchedHeaders>> getMismatchedHeaders() {
        return this.mismatchedHeaders;
    }

    private static PrerenderStatusUpdated fromJson(JsonInput input) {
        PreloadingAttemptKey key = null;
        PreloadPipelineId pipelineId = null;
        PreloadingStatus status = null;
        Optional<PrerenderFinalStatus> prerenderStatus = Optional.empty();
        Optional<String> disallowedMojoInterface = Optional.empty();
        Optional<List<PrerenderMismatchedHeaders>> mismatchedHeaders = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "key": {
                    key = (PreloadingAttemptKey)input.read(PreloadingAttemptKey.class);
                    continue block16;
                }
                case "pipelineId": {
                    pipelineId = (PreloadPipelineId)input.read(PreloadPipelineId.class);
                    continue block16;
                }
                case "status": {
                    status = (PreloadingStatus)((Object)input.read(PreloadingStatus.class));
                    continue block16;
                }
                case "prerenderStatus": {
                    prerenderStatus = Optional.ofNullable((PrerenderFinalStatus)((Object)input.read(PrerenderFinalStatus.class)));
                    continue block16;
                }
                case "disallowedMojoInterface": {
                    disallowedMojoInterface = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "mismatchedHeaders": {
                    mismatchedHeaders = Optional.ofNullable(input.readArray(PrerenderMismatchedHeaders.class));
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrerenderStatusUpdated(key, pipelineId, status, prerenderStatus, disallowedMojoInterface, mismatchedHeaders);
    }
}

