/*
 * Created on 07/ago/2011
 * Copyright 2010 by Andrea Vacondio (andrea.vacondio@gmail.com).
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License. 
 */
package org.sejda.model.outline;


/**
 * Provides methods to deal with a pdf document outline.
 * 
 * @author Andrea Vacondio
 * 
 */
public interface OutlineHandler {

    /**
     * @return the max depth level for GoTo action in the pdf document outline associated to this handler.
     */
    int getMaxGoToActionDepth();

    /**
     * @param goToActionLevel
     * @return a set of page numbers found at the given GoTo Action level
     */
    OutlineGoToPageDestinations getGoToPageDestinationForActionLevel(int goToActionLevel);
}
