/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.richfaces.model.SortOrder;
import org.richfaces.model.impl.SimpleGridDataModel;

public class ArrayDataModel
extends SimpleGridDataModel {
    private Object[] data;

    public ArrayDataModel() {
        this(null);
    }

    public ArrayDataModel(Object[] data) {
        this.setWrappedData(data);
    }

    public List loadData(int startRow, int endRow, SortOrder sortOrder) {
        if (this.data != null && this.getRowCount() > 0) {
            Object[] sortedList = this.data;
            if (sortOrder != null) {
                sortedList = new Object[this.data.length];
                System.arraycopy(this.data, 0, sortedList, 0, this.data.length);
                Comparator comparator = this.createComparator(sortOrder);
                if (comparator == null) {
                    Arrays.sort(sortedList);
                } else {
                    Arrays.sort(sortedList, comparator);
                }
            }
            Object[] subArray = new Object[endRow - startRow];
            System.arraycopy(sortedList, startRow, subArray, 0, subArray.length);
            return Arrays.asList(subArray);
        }
        return Collections.EMPTY_LIST;
    }

    public int getRowCount() {
        return this.data == null ? 0 : this.data.length;
    }

    public Object getWrappedData() {
        return this.data;
    }

    public void setWrappedData(Object data) {
        this.data = (Object[])data;
    }
}

