/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.application.StateHolder;
import org.ajax4jsf.context.ContextInitParameters;
import org.ajax4jsf.util.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxStateHolder
implements Serializable,
StateHolder {
    private static final Log _log = LogFactory.getLog(AjaxStateHolder.class);
    private static final long serialVersionUID = 6414488517358423537L;
    private static final String STATE_HOLDER = AjaxStateHolder.class.getName();
    private final LRUMap<String, LRUMap<String, StateReference>> views;
    private final int numberOfViews;

    private AjaxStateHolder(int capacity, int numberOfViews) {
        this.views = new LRUMap(capacity + 1);
        this.numberOfViews = numberOfViews;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StateHolder getInstance(FacesContext context) {
        StateHolder instance;
        if (null == context) {
            throw new NullPointerException("FacesContext parameter for get view states object is null");
        }
        ExternalContext externalContext = context.getExternalContext();
        Object session = externalContext.getSession(true);
        Map sessionMap = externalContext.getSessionMap();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Request for a view states holder instance");
        }
        if ((instance = (StateHolder)sessionMap.get(STATE_HOLDER)) == null) {
            Object object = session;
            synchronized (object) {
                instance = (StateHolder)sessionMap.get(STATE_HOLDER);
                if (null == instance) {
                    int numbersOfViewsInSession = ContextInitParameters.getNumbersOfViewsInSession(context);
                    int numbersOfLogicalViews = ContextInitParameters.getNumbersOfLogicalViews(context);
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("No AjaxStateHolder instance in session, create new for hold " + numbersOfViewsInSession + " viewId and " + numbersOfLogicalViews + " logical views for each"));
                    }
                    instance = new AjaxStateHolder(numbersOfViewsInSession, numbersOfLogicalViews);
                    sessionMap.put(STATE_HOLDER, instance);
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateInstance(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Object session = externalContext.getSession(true);
        Map sessionMap = externalContext.getSessionMap();
        Object object = session;
        synchronized (object) {
            sessionMap.put(STATE_HOLDER, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getState(FacesContext context, String viewId, String sequence) {
        if (null == viewId) {
            throw new NullPointerException("viewId parameter for get saved view state is null");
        }
        Object[] state = null;
        LRUMap<String, LRUMap<String, StateReference>> lRUMap = this.views;
        synchronized (lRUMap) {
            LRUMap viewVersions = (LRUMap)this.views.get(viewId);
            if (null != viewVersions) {
                StateReference stateReference;
                if (null != sequence && null != (stateReference = (StateReference)viewVersions.get(sequence))) {
                    state = stateReference.getState();
                }
                if (null == state && _log.isDebugEnabled()) {
                    _log.debug((Object)("No saved view state for sequence " + sequence));
                }
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("No saved view states for viewId " + viewId));
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveState(FacesContext context, String viewId, String sequence, Object[] state) {
        if (null == viewId) {
            throw new NullPointerException("viewId parameter for  save view state is null");
        }
        if (null == sequence) {
            throw new NullPointerException("sequence parameter for save view state is null");
        }
        if (null != state) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Save new viewState in session for viewId " + viewId + " and sequence " + sequence));
            }
            LRUMap<String, LRUMap<String, StateReference>> lRUMap = this.views;
            synchronized (lRUMap) {
                LRUMap<String, StateReference> viewVersions = (LRUMap<String, StateReference>)this.views.get(viewId);
                StateReference stateReference = null;
                if (null == viewVersions) {
                    viewVersions = new LRUMap<String, StateReference>(this.numberOfViews + 1);
                    this.views.put(viewId, viewVersions);
                    stateReference = new StateReference(state);
                    viewVersions.put(sequence, stateReference);
                } else {
                    stateReference = (StateReference)viewVersions.get(sequence);
                    if (null == stateReference) {
                        stateReference = new StateReference(state);
                        viewVersions.put(sequence, stateReference);
                    } else {
                        stateReference.setState(state);
                    }
                }
            }
            this.updateInstance(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream stream) throws IOException {
        LRUMap<String, LRUMap<String, StateReference>> lRUMap = this.views;
        synchronized (lRUMap) {
            stream.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    private static class StateReference
    implements Serializable {
        private Object[] state;

        public Object[] getState() {
            return this.state;
        }

        public void setState(Object[] state) {
            this.state = state;
        }

        public StateReference(Object[] state) {
            this.state = state;
        }
    }
}

