/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.component.xpointer;

import java.io.IOException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cocoon.pipeline.component.sax.SAXConsumer;
import org.apache.cocoon.pipeline.component.xpointer.PointerPart;
import org.apache.cocoon.pipeline.component.xpointer.XPointerContext;
import org.apache.cocoon.pipeline.util.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.LocatorImpl;

public final class XPointerPart
implements PointerPart {
    private static final XPathFactory XPF = XPathFactory.newInstance();
    private String expression;

    public XPointerPart(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean process(XPointerContext xpointerContext) throws SAXException, IOException {
        XPathExpression xpathExpression;
        Document document = xpointerContext.getDocument();
        XPath xpath = XPF.newXPath();
        xpath.setNamespaceContext(xpointerContext);
        try {
            xpathExpression = xpath.compile(this.expression);
        }
        catch (XPathExpressionException e) {
            throw new SAXException("XPointer: expression \"" + this.expression + "\" is not a valid XPath expression", e);
        }
        try {
            NodeList nodeList = (NodeList)xpathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodeList.getLength() > 0) {
                SAXConsumer consumer = xpointerContext.getXmlConsumer();
                LocatorImpl locator = new LocatorImpl();
                locator.setSystemId(xpointerContext.getSource().toString());
                consumer.setDocumentLocator(locator);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    DOMUtils.stream(nodeList.item(i), consumer);
                }
                return true;
            }
            if (xpointerContext.getLogger().isDebugEnabled()) {
                xpointerContext.getLogger().debug((CharSequence)("XPointer: expression \"" + this.expression + "\" gave no results."));
            }
            return false;
        }
        catch (XPathExpressionException e) {
            throw new SAXException("XPointer: impossible to select DOM fragment using expression \"" + this.expression + "\", see nested exception", e);
        }
    }
}

