/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashSet;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.config.TagBean;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.generator.TestDataGenerator2;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

public class TagTestGenerator
extends InnerGenerator {
    private static final String COMPONENT_FILE_TEMPLATE = "tagtest.vm";

    public TagTestGenerator(JSFGeneratorConfiguration config, Logger log) {
        super(config, log);
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        System.out.println("Preparing to generate test for tag class... ");
        VelocityContext context = new VelocityContext();
        context.put("generator", (Object)this);
        context.put("testDataGenerator", (Object)new TestDataGenerator2(this.getClassLoader(), this.getLog()));
        Template template = this.getTemplate();
        for (ComponentBean component : config.getComponents()) {
            TagBean tag = component.getTag();
            if (null == tag || null == tag.getClassname() || !tag.isGenerate() || tag.getTest() == null) continue;
            this.info("Create test class file for tag " + component.getTag().getSimpleClassName());
            context.put("component", (Object)component);
            if (null != component.getRenderer()) {
                context.put("renderer", (Object)component.getRenderer());
            } else {
                context.put("renderer", (Object)Boolean.FALSE);
            }
            context.put("tag", (Object)component.getTag());
            context.put("package", (Object)component.getTag().getPackageName());
            HashSet<String> importClasses = new HashSet<String>();
            for (PropertyBean property : component.getProperties()) {
                if (property.isSimpleType() || property.isHidden()) continue;
                importClasses.add(property.getClassname());
            }
            importClasses.add(component.getTag().getTest().getSuperclassname());
            context.put("imports", importClasses);
            String resultPath = component.getTag().getTest().getClassname().replace('.', '/') + ".java";
            File javaFile = new File(this.getDestDir(), resultPath);
            File javaDir = javaFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            try {
                if (javaFile.exists()) {
                    javaFile.delete();
                }
                BufferedWriter out = new BufferedWriter(new FileWriter(javaFile));
                template.merge((Context)context, (Writer)out);
                ((Writer)out).flush();
                ((Writer)out).close();
            }
            catch (Exception e) {
                throw new GeneratorException("Error create new Component JSP Tag Test Java file ", e);
            }
        }
    }

    protected String getDefaultTemplateName() {
        return COMPONENT_FILE_TEMPLATE;
    }

    public String getSetterTestName(PropertyBean property) {
        String setterName = property.getSetterName();
        String className = property.getSimpleClassName();
        StringBuilder name = new StringBuilder("test");
        name.append(Character.toUpperCase(setterName.charAt(0)));
        name.append(setterName.substring(1));
        name.append(Character.toUpperCase(className.charAt(0)));
        name.append(className.substring(1));
        return name.toString();
    }
}

