/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.config.RendererBean;
import org.ajax4jsf.builder.config.TagBean;
import org.ajax4jsf.builder.config.TagHandlerBean;
import org.ajax4jsf.builder.generator.AbstractClassStubBuilder;
import org.ajax4jsf.builder.generator.GetResourceInterceptor;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.generator.RendererCompilationContext;
import org.ajax4jsf.builder.generator.ResourceType;
import org.ajax4jsf.builder.generator.ResourcesConfigGeneratorBean;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.builder.TemplateCompiler;
import org.ajax4jsf.templatecompiler.elements.RootElement;
import org.ajax4jsf.templatecompiler.elements.TemplateElement;
import org.ajax4jsf.templatecompiler.elements.vcp.FResourceTemplateElement;
import org.ajax4jsf.templatecompiler.elements.vcp.HeaderResourceElement;
import org.ajax4jsf.templatecompiler.elements.vcp.HeaderScriptsElement;
import org.ajax4jsf.templatecompiler.elements.vcp.HeaderStylesElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesConfigParser {
    private JSFGeneratorConfiguration config;
    private Logger log;
    private File templates;
    private ResourcesConfigGeneratorBean resourcesConfigGeneratorBean;
    private Map<String, ResourcesConfigGeneratorBean> componentResourcesMap;

    public ResourcesConfigParser(JSFGeneratorConfiguration config, Logger log) {
        this.config = config;
        this.log = log;
        this.resourcesConfigGeneratorBean = new ResourcesConfigGeneratorBean();
        this.componentResourcesMap = new HashMap<String, ResourcesConfigGeneratorBean>();
    }

    public File getTemplates() {
        return this.templates;
    }

    public void setTemplates(File templates) {
        this.templates = templates;
    }

    private void addResources(ResourcesConfigGeneratorBean configBean, TemplateElement templateElement, String packageName, RendererBean renderer, BuilderConfig builderConfig) throws ClassNotFoundException {
        if (templateElement instanceof FResourceTemplateElement) {
            FResourceTemplateElement resourceTemplateElement = (FResourceTemplateElement)templateElement;
            String name = resourceTemplateElement.getName();
            configBean.addResource(name, packageName, null, true);
        } else if (templateElement instanceof RootElement) {
            RootElement rootElement = (RootElement)templateElement;
            CompilationContext compilationContext = rootElement.getComponentBean();
            this.addResource(configBean, renderer, builderConfig, compilationContext);
        } else if (templateElement instanceof HeaderResourceElement) {
            HeaderResourceElement resourceElement = (HeaderResourceElement)templateElement;
            ResourceType type = null;
            if (templateElement instanceof HeaderScriptsElement) {
                type = ResourceType.SCRIPT;
            } else if (templateElement instanceof HeaderStylesElement) {
                type = ResourceType.STYLE;
            }
            String[] paths = resourceElement.getResourcePaths();
            if (paths != null) {
                for (int i = 0; i < paths.length; ++i) {
                    String string = paths[i];
                    configBean.addResource(string, packageName, type, false);
                }
            }
        }
        ArrayList<TemplateElement> subElements = templateElement.getSubElements();
        for (TemplateElement element : subElements) {
            this.addResources(configBean, element, packageName, renderer, builderConfig);
        }
    }

    private String getResourceKey(String packageName, Object resource) {
        try {
            Class<?> resourceClass = resource.getClass();
            Method method = resourceClass.getMethod("getKey", new Class[0]);
            String resourceKey = (String)method.invoke(resource, new Object[0]);
            if (resourceKey != null && !resourceKey.equals(resourceClass.getName())) {
                ClassLoader loader = this.config.getClassLoader();
                if (loader.getResource(resourceKey) == null) {
                    String packagePath = packageName.replace('.', '/');
                    if (packagePath.length() != 0) {
                        packagePath = packagePath + "/";
                    }
                    if (loader.getResource(packagePath + resourceKey) == null) {
                        resourceKey = null;
                    }
                } else if (!resourceKey.startsWith("/")) {
                    resourceKey = "/" + resourceKey;
                }
            }
            return resourceKey;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), e);
            return null;
        }
    }

    private String addResource(ResourcesConfigGeneratorBean configBean, RendererBean renderer, BuilderConfig builderConfig, CompilationContext compilationContext) throws ClassNotFoundException {
        Class<?> cl;
        String packageName;
        block24: {
            String classname = renderer.getClassname();
            int idx = classname.lastIndexOf(46);
            packageName = idx != -1 ? classname.substring(0, idx) : "";
            ClassLoader loader = builderConfig.getLoader();
            cl = null;
            try {
                cl = loader.loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                String superclass = compilationContext.getBaseclassPackageName() + "." + compilationContext.getBaseclassName();
                if (superclass == null) break block24;
                cl = loader.loadClass(superclass);
            }
        }
        if (cl != null) {
            try {
                String resourceName;
                GetResourceInterceptor interceptor = new GetResourceInterceptor(builderConfig.getLoader());
                Object instance = AbstractClassStubBuilder.buildStub(cl, interceptor, builderConfig.getLoader());
                Object[] result = null;
                Method method = null;
                HashSet<String> locatedResources = new HashSet<String>();
                Class<?> cl1 = instance.getClass();
                while (cl1 != null && method == null) {
                    try {
                        method = cl1.getDeclaredMethod("getStyles", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        cl1 = cl1.getSuperclass();
                    }
                }
                if (method != null) {
                    method.setAccessible(true);
                    result = (Object[])method.invoke(instance, new Object[0]);
                    if (result instanceof Object[]) {
                        for (Object object : result) {
                            resourceName = interceptor.getResourceName(object);
                            if (resourceName == null) {
                                resourceName = this.getResourceKey(packageName, object);
                            }
                            if (resourceName == null) continue;
                            locatedResources.add(resourceName);
                            configBean.addResource(resourceName, packageName, ResourceType.STYLE, false);
                        }
                    }
                }
                method = null;
                cl1 = instance.getClass();
                while (cl1 != null && method == null) {
                    try {
                        method = cl1.getDeclaredMethod("getScripts", new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        cl1 = cl1.getSuperclass();
                    }
                }
                if (method != null) {
                    List<String> list;
                    method.setAccessible(true);
                    result = (Object[])method.invoke(instance, new Object[0]);
                    if (result instanceof Object[]) {
                        for (Object object : result) {
                            resourceName = interceptor.getResourceName(object);
                            if (resourceName == null) {
                                resourceName = this.getResourceKey(packageName, object);
                            }
                            if (resourceName == null) continue;
                            locatedResources.add(resourceName);
                            configBean.addResource(resourceName, packageName, ResourceType.SCRIPT, false);
                        }
                    }
                    if ((list = interceptor.getList()) != null) {
                        list.removeAll(locatedResources);
                        for (String resourceName2 : list) {
                            this.log.warn("Error detecting resource type: " + resourceName2);
                            configBean.addResource(resourceName2, packageName, null, false);
                        }
                    }
                }
            }
            catch (SecurityException e) {
                builderConfig.getLog().error(e.getMessage(), e);
            }
            catch (IllegalArgumentException e) {
                builderConfig.getLog().error(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                builderConfig.getLog().error(e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                builderConfig.getLog().error(e.getMessage(), e);
            }
        }
        return packageName;
    }

    private void addResources(ResourcesConfigGeneratorBean configBean, RendererBean renderer, BuilderConfig builderConfig) throws CompilationException, IOException, ClassNotFoundException {
        if (null != renderer) {
            RendererCompilationContext compilationContext = new RendererCompilationContext(this.log, this.config.getClassLoader(), this.config);
            if (renderer.isGenerate()) {
                String templateString = renderer.getTemplate();
                if (templateString != null) {
                    File template = null != this.getTemplates() ? new File(this.getTemplates(), templateString) : new File(templateString);
                    TemplateCompiler templateCompiler = new TemplateCompiler();
                    FileInputStream templateStream = new FileInputStream(template);
                    templateCompiler.processing(templateStream, compilationContext);
                    TemplateElement root = compilationContext.getTree();
                    String classname = renderer.getClassname();
                    int idx = classname.lastIndexOf(46);
                    String packageName = idx != -1 ? classname.substring(0, idx) : "";
                    this.addResources(configBean, root, packageName, renderer, builderConfig);
                }
            } else {
                this.addResource(configBean, renderer, builderConfig, compilationContext);
            }
        }
    }

    public void parse(BuilderConfig config) throws CompilationException, IOException, ClassNotFoundException {
        List<ComponentBean> components = config.getComponents();
        for (ComponentBean componentBean : components) {
            TagHandlerBean taghandler;
            ResourcesConfigGeneratorBean localBeanInstance = new ResourcesConfigGeneratorBean();
            RendererBean rendererBean = componentBean.getRenderer();
            this.addResources(localBeanInstance, rendererBean, config);
            String componentName = null;
            TagBean tag = componentBean.getTag();
            if (tag != null) {
                componentName = tag.getName();
            }
            if (componentName == null && (taghandler = componentBean.getTaghandler()) != null) {
                componentName = taghandler.getName();
            }
            if (componentName != null) {
                this.componentResourcesMap.put(componentName, localBeanInstance);
            }
            this.resourcesConfigGeneratorBean.merge(localBeanInstance);
        }
        List<RendererBean> renderers = config.getRenderers();
        for (RendererBean rendererBean : renderers) {
            this.addResources(this.resourcesConfigGeneratorBean, rendererBean, config);
        }
    }

    public ResourcesConfigGeneratorBean getResourcesConfigGeneratorBean() {
        return this.resourcesConfigGeneratorBean;
    }

    public Map<String, ResourcesConfigGeneratorBean> getComponentResourcesMap() {
        return this.componentResourcesMap;
    }
}

