/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.generator.FacesConfigGenerator;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.ajax4jsf.builder.generator.ResourcesConfigGeneratorBean;
import org.ajax4jsf.builder.generator.ResourcesConfigGeneratorBeanEntry;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResourcesConfigGenerator
extends FacesConfigGenerator {
    private File resourcesConfig;
    private File templatesDirectory;
    private ResourcesConfigGeneratorBean resourcesConfigGeneratorBean;
    private static final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public ResourcesConfigGenerator(JSFGeneratorConfiguration task, Logger log) {
        super(task, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseXCSSResource(String resourcePath, final ResourcesConfigGeneratorBean bean) throws SAXException, IOException, ParserConfigurationException {
        InputStream resourceStream = this.getClassLoader().getResourceAsStream(resourcePath);
        if (resourceStream != null) {
            this.debug("XCSS file exists in classpath");
            try {
                SAXParser parser = parserFactory.newSAXParser();
                parser.parse(resourceStream, new DefaultHandler(){

                    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                        String value;
                        super.startElement(uri, localName, name, attributes);
                        if ("f:resource".equals(name) && (value = attributes.getValue("f:key")) != null) {
                            ResourcesConfigGenerator.this.debug("Adding resource: " + value);
                            bean.addResource(value, "", null, true);
                        }
                    }
                });
            }
            finally {
                try {
                    resourceStream.close();
                }
                catch (IOException e) {
                    this.getLog().error(e.getLocalizedMessage(), e);
                }
            }
        }
        this.getLog().error("Resource " + resourcePath + " hasn't been found!");
    }

    private boolean isXCSSPath(String resourcePath) {
        return resourcePath != null && resourcePath.endsWith(".xcss");
    }

    public void createFiles(BuilderConfig config) throws GeneratorException {
        VelocityContext context = new VelocityContext();
        Template template = this.getTemplate();
        try {
            String includedContent;
            final ResourcesConfigGeneratorBean bean = new ResourcesConfigGeneratorBean();
            if (this.resourcesConfigGeneratorBean != null) {
                bean.merge(this.resourcesConfigGeneratorBean);
            }
            if ((includedContent = this.getIncludeContent()) != null && includedContent.length() != 0) {
                String parseableContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><resource-config>" + includedContent + "</resource-config>";
                SAXParser parser = parserFactory.newSAXParser();
                parser.parse(new InputSource(new StringReader(parseableContent)), new DefaultHandler(){
                    private StringBuilder path;

                    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
                        super.startElement(uri, localName, name, attributes);
                        if ("path".equals(name)) {
                            this.path = new StringBuilder();
                        }
                    }

                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.path != null) {
                            this.path.append(ch, start, length);
                        }
                    }

                    public void endElement(String uri, String localName, String name) throws SAXException {
                        super.endElement(uri, localName, name);
                        if ("resource".equals(name)) {
                            String resourcePath;
                            if (this.path != null && this.path.length() != 0 && ResourcesConfigGenerator.this.isXCSSPath(resourcePath = this.path.toString().trim())) {
                                ResourcesConfigGenerator.this.debug("XCSS file detected: " + resourcePath);
                                try {
                                    ResourcesConfigGenerator.this.parseXCSSResource(resourcePath, bean);
                                }
                                catch (IOException e) {
                                    throw new SAXException(e.getLocalizedMessage(), e);
                                }
                                catch (ParserConfigurationException e) {
                                    throw new SAXException(e.getLocalizedMessage(), e);
                                }
                            }
                            this.path = null;
                        }
                    }
                });
            }
            LinkedHashSet<String> pathResourcesSet = new LinkedHashSet<String>();
            for (ResourcesConfigGeneratorBeanEntry entry : bean.getDependencies()) {
                if (!entry.isPathResource()) continue;
                pathResourcesSet.add(entry.getPath());
            }
            for (String resourcePath : pathResourcesSet) {
                if (!this.isXCSSPath(resourcePath)) continue;
                this.debug("XCSS file detected: " + resourcePath);
                this.parseXCSSResource(resourcePath, bean);
            }
            HashMap<String, String> classResources = new HashMap<String, String>();
            HashMap<String, String> pathResources = new HashMap<String, String>();
            for (ResourcesConfigGeneratorBeanEntry entry : bean.getDependencies()) {
                if (entry.isPathResource()) {
                    pathResources.put(entry.getName(), entry.getPath());
                    continue;
                }
                classResources.put(entry.getName(), entry.getPath());
            }
            context.put("classResources", classResources);
            context.put("pathResources", pathResources);
            context.put("resourcesConfig", (Object)this);
            File configFile = this.getResourcesConfig();
            File javaDir = configFile.getParentFile();
            if (!javaDir.exists()) {
                javaDir.mkdirs();
            }
            if (configFile.exists()) {
                configFile.delete();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(configFile));
            template.merge((Context)context, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
        }
        catch (Exception e) {
            throw new GeneratorException("Error create new resources-config.xml ", e);
        }
    }

    protected String getRootTag() {
        return "resource-config";
    }

    public File getResourcesConfig() {
        return this.resourcesConfig;
    }

    public void setResourcesConfig(File resourcesConfig) {
        this.resourcesConfig = resourcesConfig;
    }

    protected String getDefaultTemplateName() {
        return "resources-config.vm";
    }

    public void setTemplates(File templatesDirectory) {
        this.templatesDirectory = templatesDirectory;
    }

    public File getTemplates() {
        return this.templatesDirectory;
    }

    public void setResourcesConfigGeneratorBean(ResourcesConfigGeneratorBean resourcesConfigGeneratorBean) {
        this.resourcesConfigGeneratorBean = resourcesConfigGeneratorBean;
    }

    public ResourcesConfigGeneratorBean getResourcesConfigGeneratorBean() {
        return this.resourcesConfigGeneratorBean;
    }
}

