/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.channel;

import java.net.SocketAddress;
import org.python.netty.channel.AbstractChannel;
import org.python.netty.channel.ChannelMetadata;
import org.python.netty.channel.ChannelOutboundBuffer;
import org.python.netty.channel.ChannelPromise;
import org.python.netty.channel.ServerChannel;
import org.python.netty.util.ReferenceCountUtil;

public abstract class AbstractServerChannel
extends AbstractChannel
implements ServerChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);

    protected AbstractServerChannel() {
        super(null);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public SocketAddress remoteAddress() {
        return null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultServerUnsafe();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        throw new UnsupportedOperationException();
    }

    private final class DefaultServerUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultServerUnsafe() {
        }

        @Override
        public void write(Object msg, ChannelPromise promise) {
            ReferenceCountUtil.release(msg);
            this.reject(promise);
        }

        @Override
        public void flush() {
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            this.reject(promise);
        }

        private void reject(ChannelPromise promise) {
            this.safeSetFailure(promise, new UnsupportedOperationException());
        }
    }
}

