/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timepicker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.apache.commons.lang3.LocaleUtils;
import org.primefaces.component.api.Widget;
import org.primefaces.extensions.event.BeforeShowEvent;
import org.primefaces.extensions.event.CloseEvent;
import org.primefaces.extensions.event.TimeSelectEvent;
import org.primefaces.util.ArrayUtils;
import org.primefaces.util.HTML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="primefaces.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="primefaces.js"), @ResourceDependency(library="primefaces-extensions", name="primefaces-extensions.js"), @ResourceDependency(library="primefaces-extensions", name="timepicker/timepicker.css"), @ResourceDependency(library="primefaces-extensions", name="timepicker/timepicker.js")})
public class TimePicker
extends HtmlInputText
implements Widget {
    public static final String COMPONENT_TYPE = "org.primefaces.extensions.component.TimePicker";
    public static final String COMPONENT_FAMILY = "org.primefaces.extensions.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.extensions.component.TimePickerRenderer";
    private static final String OPTIMIZED_PACKAGE = "org.primefaces.extensions.component.";
    public static final String CONTAINER_CLASS = "pe-timepicker ui-widget ui-corner-all";
    public static final String INPUT_CLASS = "ui-inputfield pe-timepicker-input ui-state-default ui-corner-all";
    public static final String UP_BUTTON_CLASS = "pe-timepicker-button pe-timepicker-up ui-corner-tr ui-button ui-widget ui-state-default ui-button-text-only";
    public static final String DOWN_BUTTON_CLASS = "pe-timepicker-button pe-timepicker-down ui-corner-br ui-button ui-widget ui-state-default ui-button-text-only";
    public static final String UP_ICON_CLASS = "ui-icon ui-icon-triangle-1-n";
    public static final String DOWN_ICON_CLASS = "ui-icon ui-icon-triangle-1-s";
    public static final String[] INPUT_TEXT_ATTRS = ArrayUtils.concat((String[][])new String[][]{{"accesskey", "alt", "autocomplete", "dir", "lang", "maxlength", "size", "tabindex", "title"}, HTML.COMMON_EVENTS, HTML.CHANGE_SELECT_EVENTS, HTML.BLUR_FOCUS_EVENTS});
    public static final String TIME_MESSAGE_KEY = "javax.faces.converter.DateTimeConverter.TIME";
    private Locale appropriateLocale;
    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList("blur", "change", "valueChange", "click", "dblclick", "focus", "keydown", "keypress", "keyup", "mousedown", "mousemove", "mouseout", "mouseover", "mouseup", "beforeShow", "timeSelect", "close"));
    private Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>();

    public TimePicker() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String widgetVar) {
        this.setAttribute(PropertyKeys.widgetVar, widgetVar);
    }

    public String getTimeSeparator() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.timeSeparator), (Object)":");
    }

    public void setTimeSeparator(String timeSeparator) {
        this.setAttribute(PropertyKeys.timeSeparator, timeSeparator);
    }

    public boolean isShowPeriod() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showPeriod), (Object)false);
    }

    public void setShowPeriod(boolean showPeriod) {
        this.setAttribute(PropertyKeys.showPeriod, showPeriod);
    }

    public String getMode() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.mode), (Object)"spinner");
    }

    public void setMode(String mode) {
        this.setAttribute(PropertyKeys.mode, mode);
    }

    public String getDialogPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.dialogPosition), (Object)"left top");
    }

    public void setDialogPosition(String dialogPosition) {
        this.setAttribute(PropertyKeys.dialogPosition, dialogPosition);
    }

    public String getInputPosition() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.inputPosition), (Object)"left bottom");
    }

    public void setInputPosition(String inputPosition) {
        this.setAttribute(PropertyKeys.inputPosition, inputPosition);
    }

    public int getStartHours() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.startHours), (Object)0);
    }

    public void setStartHours(int startHours) {
        this.setAttribute(PropertyKeys.startHours, startHours);
    }

    public int getEndHours() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.endHours), (Object)23);
    }

    public void setEndHours(int endHours) {
        this.setAttribute(PropertyKeys.endHours, endHours);
    }

    public int getStartMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.startMinutes), (Object)0);
    }

    public void setStartMinutes(int startMinutes) {
        this.setAttribute(PropertyKeys.startMinutes, startMinutes);
    }

    public int getEndMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.endMinutes), (Object)55);
    }

    public void setEndMinutes(int endMinutes) {
        this.setAttribute(PropertyKeys.endMinutes, endMinutes);
    }

    public int getIntervalMinutes() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.intervalMinutes), (Object)5);
    }

    public void setIntervalMinutes(int intervalMinutes) {
        this.setAttribute(PropertyKeys.intervalMinutes, intervalMinutes);
    }

    public int getRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rows), (Object)4);
    }

    public void setRows(int rows) {
        this.setAttribute(PropertyKeys.rows, rows);
    }

    public boolean isShowHours() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showHours), (Object)true);
    }

    public void setShowHours(boolean showHours) {
        this.setAttribute(PropertyKeys.showHours, showHours);
    }

    public boolean isShowMinutes() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showMinutes), (Object)true);
    }

    public void setShowMinutes(boolean showMinutes) {
        this.setAttribute(PropertyKeys.showMinutes, showMinutes);
    }

    public boolean isShowCloseButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showCloseButton), (Object)false);
    }

    public void setShowCloseButton(boolean showCloseButton) {
        this.setAttribute(PropertyKeys.showCloseButton, showCloseButton);
    }

    public boolean isShowDeselectButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showDeselectButton), (Object)false);
    }

    public void setShowDeselectButton(boolean showDeselectButton) {
        this.setAttribute(PropertyKeys.showDeselectButton, showDeselectButton);
    }

    public boolean isShowNowButton() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.showNowButton), (Object)false);
    }

    public void setShowNowButton(boolean showNowButton) {
        this.setAttribute(PropertyKeys.showNowButton, showNowButton);
    }

    public String getOnHourShow() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onHourShow), null);
    }

    public void setOnHourShow(String onHourShow) {
        this.setAttribute(PropertyKeys.onHourShow, onHourShow);
    }

    public String getOnMinuteShow() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.onMinuteShow), null);
    }

    public void setOnMinuteShow(String onMinuteShow) {
        this.setAttribute(PropertyKeys.onMinuteShow, onMinuteShow);
    }

    public Object getLocale() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.locale), null);
    }

    public void setLocale(Object locale) {
        this.setAttribute(PropertyKeys.locale, locale);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Locale calculateLocale(FacesContext fc) {
        if (this.appropriateLocale != null) return this.appropriateLocale;
        Object userLocale = this.getLocale();
        if (userLocale != null) {
            if (userLocale instanceof String) {
                this.appropriateLocale = LocaleUtils.toLocale((String)((String)userLocale));
                return this.appropriateLocale;
            } else {
                if (!(userLocale instanceof Locale)) throw new IllegalArgumentException(userLocale.getClass() + " is not a valid locale for timepicker:" + this.getClientId(fc));
                this.appropriateLocale = (Locale)userLocale;
            }
            return this.appropriateLocale;
        } else {
            this.appropriateLocale = fc.getViewRoot().getLocale();
        }
        return this.appropriateLocale;
    }

    public boolean isInline() {
        return this.getMode().equalsIgnoreCase("inline");
    }

    public boolean isSpinner() {
        return this.getMode().equalsIgnoreCase("spinner");
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext fc = FacesContext.getCurrentInstance();
        String eventName = (String)fc.getExternalContext().getRequestParameterMap().get("javax.faces.behavior.event");
        if (this.isSelfRequest(fc) && event instanceof AjaxBehaviorEvent) {
            if ("timeSelect".equals(eventName)) {
                this.customEvents.put("timeSelect", (AjaxBehaviorEvent)event);
                return;
            }
            if ("beforeShow".equals(eventName)) {
                BeforeShowEvent beforeShowEvent = new BeforeShowEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior());
                beforeShowEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)beforeShowEvent);
                return;
            }
            if ("close".equals(eventName)) {
                CloseEvent closeEvent = new CloseEvent((UIComponent)this, ((AjaxBehaviorEvent)event).getBehavior());
                closeEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)closeEvent);
                return;
            }
        }
        super.queueEvent(event);
    }

    public void validate(FacesContext fc) {
        super.validate(fc);
        if (this.isValid()) {
            Iterator<String> customEventIter = this.customEvents.keySet().iterator();
            while (customEventIter.hasNext()) {
                AjaxBehaviorEvent behaviorEvent = this.customEvents.get(customEventIter.next());
                TimeSelectEvent timeSelectEvent = new TimeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), (Date)this.getValue());
                if (behaviorEvent.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
                    timeSelectEvent.setPhaseId(PhaseId.PROCESS_VALIDATIONS);
                }
                super.queueEvent((FacesEvent)timeSelectEvent);
            }
        }
    }

    public String getTimePattern24() {
        return "HH" + this.getTimeSeparator() + "mm";
    }

    public String getTimePattern12() {
        return "hh" + this.getTimeSeparator() + "mm a";
    }

    private boolean isSelfRequest(FacesContext fc) {
        return this.getClientId(fc).equals(fc.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public String resolveWidgetVar() {
        FacesContext context = FacesContext.getCurrentInstance();
        String userWidgetVar = (String)this.getAttributes().get(PropertyKeys.widgetVar.toString());
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    public void setAttribute(PropertyKeys property, Object value) {
        String cname;
        this.getStateHelper().put((Serializable)((Object)property), value);
        ArrayList<String> setAttributes = (ArrayList<String>)this.getAttributes().get("javax.faces.component.UIComponentBase.attributesThatAreSet");
        if (setAttributes == null && (cname = ((Object)((Object)this)).getClass().getName()) != null && cname.startsWith(OPTIMIZED_PACKAGE)) {
            setAttributes = new ArrayList<String>(6);
            this.getAttributes().put("javax.faces.component.UIComponentBase.attributesThatAreSet", setAttributes);
        }
        if (setAttributes != null && value == null) {
            String attributeName = property.toString();
            ValueExpression ve = this.getValueExpression(attributeName);
            if (ve == null) {
                setAttributes.remove(attributeName);
            } else if (!setAttributes.contains(attributeName)) {
                setAttributes.add(attributeName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        timeSeparator,
        showPeriod,
        dialogPosition,
        inputPosition,
        mode,
        startHours,
        endHours,
        startMinutes,
        endMinutes,
        intervalMinutes,
        rows,
        showHours,
        showMinutes,
        showCloseButton,
        showNowButton,
        showDeselectButton,
        onHourShow,
        onMinuteShow,
        locale;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

