/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.timeline;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.timeline.Timeline;
import org.primefaces.extensions.model.timeline.TimelineEvent;
import org.primefaces.extensions.util.FastStringWriter;
import org.primefaces.renderkit.CoreRenderer;

public class TimelineRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Timeline timeline = (Timeline)component;
        this.encodeMarkup(context, timeline);
        this.encodeScript(context, timeline);
    }

    protected void encodeMarkup(FacesContext context, Timeline component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (component.getStyle() != null) {
            writer.writeAttribute("style", (Object)component.getStyle(), "style");
        }
        if (component.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)component.getStyleClass(), "styleClass");
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Timeline component) throws IOException {
        List model;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = component.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function() {");
        writer.write("PrimeFacesExt.cw('Timeline', '" + component.resolveWidgetVar() + "',{");
        writer.write("id:\"" + clientId + "\"");
        writer.write(",axisPosition:\"" + component.getAxisPosition() + "\"");
        writer.write(",eventStyle:\"" + component.getEventStyle() + "\"");
        writer.write(",height:\"" + component.getHeight() + "\"");
        writer.write(",width:\"" + component.getWidth() + "\"");
        writer.write(",showNavigation:" + component.getShowNavigation());
        if (component.getValue() instanceof org.primefaces.extensions.model.timeline.Timeline) {
            org.primefaces.extensions.model.timeline.Timeline timeline = (org.primefaces.extensions.model.timeline.Timeline)component.getValue();
            writer.write(",dataSource: [");
            Iterator<TimelineEvent> eventIter = timeline.getEvents().iterator();
            while (eventIter.hasNext()) {
                this.encodeEvent(context, component, eventIter.next(), null, timeline.getId());
                if (!eventIter.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        } else if (component.getValue() instanceof List && !(model = (List)component.getValue()).isEmpty()) {
            boolean hasGroup = model.size() > 1;
            writer.write(",dataSource: [");
            Iterator it = model.iterator();
            while (it.hasNext()) {
                org.primefaces.extensions.model.timeline.Timeline timeline = (org.primefaces.extensions.model.timeline.Timeline)it.next();
                String groupName = hasGroup ? timeline.getTitle() : null;
                Iterator<TimelineEvent> eventIter = timeline.getEvents().iterator();
                while (eventIter.hasNext()) {
                    this.encodeEvent(context, component, eventIter.next(), groupName, timeline.getId());
                    if (!eventIter.hasNext()) continue;
                    writer.write(",");
                }
                if (!it.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
        }
        this.encodeClientBehaviors(context, component);
        writer.write("},true);});");
        this.endScript(writer);
    }

    protected void encodeEvent(FacesContext context, Timeline component, TimelineEvent event, String groupName, String timelineId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.write("{");
        writer.write("\"timelineId\":\"" + timelineId + "\"");
        writer.write(",\"id\":\"" + event.getId() + "\"");
        writer.write(",\"start\":" + TimelineRenderer.createJsDate(event.getStartDate().getTime()));
        writer.write(",\"content\":\"");
        if (component.getChildCount() > 0) {
            if (StringUtils.isNotBlank((CharSequence)component.getVar())) {
                context.getExternalContext().getRequestMap().put(component.getVar(), event);
            }
            FastStringWriter fsw = new FastStringWriter();
            ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)fsw);
            context.setResponseWriter(clonedWriter);
            this.renderChildren(context, (UIComponent)component);
            context.setResponseWriter(writer);
            writer.write(this.escapeText(fsw.toString()));
        } else {
            writer.write(this.escapeText(event.getTitle()));
        }
        writer.write("\"");
        if (event.getEndDate() != null) {
            writer.write(",\"end\":" + TimelineRenderer.createJsDate(event.getEndDate().getTime()));
        }
        if (groupName != null) {
            writer.write(",\"group\":\"" + groupName + "\"");
        }
        if (StringUtils.isNotBlank((CharSequence)event.getStyleClass())) {
            writer.write(",\"className\":\"" + event.getStyleClass() + "\"");
        }
        writer.write("}");
    }

    private static String createJsDate(long milliseconds) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("new Date(");
        sb.append(milliseconds).append(')');
        return sb.toString();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

