/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.knopflerfish.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.io.FileUtils;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.BundleReference;
import org.ops4j.pax.runner.platform.Configuration;
import org.ops4j.pax.runner.platform.PlatformBuilder;
import org.ops4j.pax.runner.platform.PlatformContext;
import org.ops4j.pax.runner.platform.PlatformException;
import org.ops4j.util.collections.PropertiesWriter;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnopflerfishPlatformBuilderF200T233
implements PlatformBuilder {
    private static final Log LOGGER = LogFactory.getLog(KnopflerfishPlatformBuilderF200T233.class);
    private static final String PROVIDER_NAME = "knopflerfish";
    private static final String MAIN_CLASS_NAME = "org.knopflerfish.framework.Main";
    private static final String CONFIG_DIRECTORY = "knopflerfish";
    private static final String CONFIG_INI = "config.ini";
    private static final String CACHE_DIRECTORY = "fwdir";
    private static final String CONSOLE_PROFILE = "tui";
    private static final String SEPARATOR = " ";
    private final BundleContext m_bundleContext;
    private final String m_version;

    public KnopflerfishPlatformBuilderF200T233(BundleContext bundleContext, String version) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        NullArgumentException.validateNotNull(version, "Version");
        this.m_bundleContext = bundleContext;
        this.m_version = version;
    }

    @Override
    public void prepare(PlatformContext context) throws PlatformException {
        NullArgumentException.validateNotNull(context, "Platform context");
        List<BundleReference> bundles = context.getBundles();
        OutputStream os = null;
        try {
            File workingDirectory = context.getWorkingDirectory();
            File configDirectory = new File(workingDirectory, "knopflerfish");
            configDirectory.mkdirs();
            File configFile = new File(configDirectory, CONFIG_INI);
            configFile.createNewFile();
            LOGGER.debug("Create knopflerfish configuration ini file [" + configFile + "]");
            Configuration configuration = context.getConfiguration();
            Boolean usePersistedState = configuration.usePersistedState();
            if (usePersistedState != null && !usePersistedState.booleanValue()) {
                File fwdir = new File(configDirectory, CACHE_DIRECTORY);
                LOGGER.trace("Cleaning cache folder [" + fwdir + "]");
                FileUtils.delete(fwdir);
            }
            os = new FileOutputStream(configFile);
            PropertiesWriter writer = new PropertiesWriter(os, SEPARATOR);
            this.writeHeader(writer);
            writer.append("#############################");
            writer.append(" Knopflerfish settings");
            writer.append("#############################");
            writer.append("-Dorg.osgi.provisioning.spid", "knopflerfish").append("-Dorg.knopflerfish.verbosity", "0").append("-Doscar.repository.url", "http://www.knopflerfish.org/repo/repository.xml").append("-Dorg.knopflerfish.framework.usingwrapperscript", "false").append("-Dorg.knopflerfish.framework.exitonshutdown", "true").append("-Dorg.knopflerfish.framework.debug.packages", "false").append("-Dorg.knopflerfish.framework.debug.errors", "true").append("-Dorg.knopflerfish.framework.debug.classloader", "false").append("-Dorg.knopflerfish.framework.debug.startlevel", "false").append("-Dorg.knopflerfish.framework.debug.ldap", "false").append("-Dorg.knopflerfish.startlevel.use", "true");
            writer.append("-Dorg.osgi.framework.executionenvironment", context.getExecutionEnvironment());
            String bootDelegation = context.getConfiguration().getBootDelegation();
            if (bootDelegation != null) {
                writer.append("-Dorg.osgi.framework.bootdelegation", bootDelegation);
            }
            writer.append("-Dorg.osgi.framework.system.packages", context.getSystemPackages());
            Integer startLevel = configuration.getStartLevel();
            if (startLevel != null) {
                writer.append();
                writer.append(" Framework start level");
                writer.appendRaw("-startlevel " + startLevel.toString());
            }
            if (bundles != null && bundles.size() > 0) {
                writer.append();
                writer.append("#############################");
                writer.append(" Client bundles to install");
                writer.append("#############################");
                this.appendBundles(writer, bundles, context, configuration.getBundleStartLevel());
            }
            writer.append();
            writer.append("#############################");
            writer.append(" System properties");
            writer.append("#############################");
            this.appendProperties(writer, context.getProperties());
            Integer bundleStartLevel = configuration.getBundleStartLevel();
            if (bundleStartLevel != null) {
                writer.append();
                writer.append(" Initial bundles start level");
                writer.appendRaw("-initlevel " + bundleStartLevel.toString());
            }
            writer.write();
        }
        catch (IOException e) {
            throw new PlatformException("Could not create knopflerfish configuration file", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new PlatformException("Could not create knopflerfish configuration file", e);
                }
            }
        }
    }

    private void appendProperties(PropertiesWriter writer, Properties properties) {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                writer.append("-D" + key, properties.getProperty(key));
            }
        }
    }

    private void appendBundles(PropertiesWriter writer, List<BundleReference> bundles, PlatformContext context, Integer defaultStartlevel) throws MalformedURLException, PlatformException {
        TreeMap<Integer, ArrayList<String>> bundlesMap = new TreeMap<Integer, ArrayList<String>>();
        for (BundleReference bundleReference : bundles) {
            ArrayList<String> bundlesList;
            URL url = bundleReference.getURL();
            if (url == null) {
                throw new PlatformException("URL of the bundle to install cannot be null");
            }
            Boolean shouldStart = bundleReference.shouldStart();
            String propertyName = shouldStart != null && shouldStart != false ? "-istart " : "-install ";
            Integer startLevel = bundleReference.getStartLevel();
            if (startLevel == null) {
                startLevel = defaultStartlevel;
            }
            if ((bundlesList = (ArrayList<String>)bundlesMap.get(startLevel)) == null) {
                bundlesList = new ArrayList<String>();
                bundlesMap.put(startLevel, bundlesList);
            }
            bundlesList.add(propertyName + context.getFilePathStrategy().normalizeAsUrl(url));
        }
        for (Map.Entry entry : bundlesMap.entrySet()) {
            writer.appendRaw("-initlevel " + entry.getKey());
            for (String reference : (List)entry.getValue()) {
                writer.appendRaw(reference);
            }
        }
    }

    private void writeHeader(PropertiesWriter writer) {
        writer.append("###############################################");
        writer.append("              ______  ________  __  __        #");
        writer.append("             / __  / /  __   / / / / /        #");
        writer.append("            /  ___/ /  __   / _\\ \\ _/         #");
        writer.append("           /  /    /  / /  / / _\\ \\           #");
        writer.append("          /__/    /__/ /__/ /_/ /_/           #");
        writer.append("                                              #");
        writer.append(" Pax Runner from OPS4J - http://www.ops4j.org #");
        writer.append("###############################################");
        writer.append();
    }

    @Override
    public String getMainClassName() {
        return MAIN_CLASS_NAME;
    }

    @Override
    public String[] getArguments(PlatformContext context) {
        NullArgumentException.validateNotNull(context, "Platform context");
        return new String[]{"-xargs", context.getFilePathStrategy().normalizeAsUrl(new File(new File(context.getWorkingDirectory(), "knopflerfish"), CONFIG_INI))};
    }

    @Override
    public String[] getVMOptions(PlatformContext context) {
        NullArgumentException.validateNotNull(context, "Platform context");
        ArrayList<String> vmOptions = new ArrayList<String>();
        File workingDirectory = context.getWorkingDirectory();
        vmOptions.add("-Dorg.osgi.framework.dir=" + context.getFilePathStrategy().normalizeAsPath(new File(new File(workingDirectory, "knopflerfish"), CACHE_DIRECTORY)));
        return vmOptions.toArray(new String[vmOptions.size()]);
    }

    @Override
    public InputStream getDefinition(Configuration configuration) throws IOException {
        String definitionFile = "META-INF/platform-knopflerfish/definition-" + this.m_version + ".xml";
        URL url = this.m_bundleContext.getBundle().getResource(definitionFile);
        if (url == null) {
            throw new FileNotFoundException(definitionFile + " could not be found");
        }
        return url.openStream();
    }

    @Override
    public String getRequiredProfile(PlatformContext context) {
        Boolean console = context.getConfiguration().startConsole();
        if (console == null || !console.booleanValue()) {
            return null;
        }
        return CONSOLE_PROFILE;
    }

    public String toString() {
        return "Knopflerfish " + this.m_version;
    }

    @Override
    public String getProviderName() {
        return "knopflerfish";
    }

    @Override
    public String getProviderVersion() {
        return this.m_version;
    }
}

