/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.common;

import java.net.MalformedURLException;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.ScannedBundleBean;

public class ScannedFileBundle
extends ScannedBundleBean {
    private static final String SYNTAX = "bundle_url[@start_level][@nostart][@update]";

    public ScannedFileBundle(String reference) throws MalformedSpecificationException {
        if (reference == null || "".equals(reference.trim())) {
            throw new MalformedSpecificationException("Reference cannot be null or empty");
        }
        if (reference.trim().length() == 0) {
            throw new MalformedSpecificationException("Path cannot be empty. Syntax bundle_url[@start_level][@nostart][@update]");
        }
        if (reference.startsWith("@") || reference.endsWith("@")) {
            throw new MalformedSpecificationException("Path cannot start or end with @. Syntax bundle_url[@start_level][@nostart][@update]");
        }
        String[] segments = reference.split("@");
        this.setLocation(segments[0]);
        if (segments.length > 1) {
            for (int i = 1; i < segments.length; ++i) {
                try {
                    this.parseSegment(segments[i].trim());
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new MalformedSpecificationException(e);
                }
            }
        }
        if (this.shouldStart() == null) {
            this.setShouldStart(true);
        }
        if (this.shouldUpdate() == null) {
            this.setShouldUpdate(false);
        }
    }

    public ScannedFileBundle(String reference, Integer defaultStartLevel, Boolean defaultShouldStart, Boolean defaultShouldUpdate) throws MalformedURLException {
        this(reference);
        if (defaultStartLevel != null && this.getStartLevel() == null) {
            this.setStartLevel(defaultStartLevel);
        }
        if (defaultShouldStart != null && (this.shouldStart() == null || this.shouldStart().booleanValue())) {
            this.setShouldStart(defaultShouldStart);
        }
        if (!(defaultShouldUpdate == null || this.shouldUpdate() != null && this.shouldUpdate().booleanValue())) {
            this.setShouldUpdate(defaultShouldUpdate);
        }
    }

    private void parseSegment(String segment) throws MalformedURLException {
        if (this.shouldStart() == null && segment.equalsIgnoreCase("nostart")) {
            this.setShouldStart(false);
            return;
        }
        if (this.shouldUpdate() == null && segment.equalsIgnoreCase("update")) {
            this.setShouldUpdate(true);
            return;
        }
        if (this.getStartLevel() == null) {
            try {
                this.setStartLevel(Integer.parseInt(segment));
                return;
            }
            catch (NumberFormatException e) {
                throw new MalformedURLException("Invalid option [" + segment + "]. Syntax " + SYNTAX);
            }
        }
        throw new MalformedURLException("Duplicate option [" + segment + "]. Syntax " + SYNTAX);
    }
}

