/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.Objects;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.silent.Isotope;

public class AtomType
extends Isotope
implements IAtomType,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7950397716808229972L;
    IBond.Order maxBondOrder = null;
    Double bondOrderSum = (Double)CDKConstants.UNSET;
    Double covalentRadius = (Double)CDKConstants.UNSET;
    protected Integer formalCharge = (Integer)CDKConstants.UNSET;
    protected IAtomType.Hybridization hybridization = (IAtomType.Hybridization)CDKConstants.UNSET;
    protected Integer electronValency = (Integer)CDKConstants.UNSET;
    protected Integer formalNeighbourCount = (Integer)CDKConstants.UNSET;
    private String identifier = (String)CDKConstants.UNSET;

    public AtomType(String elementSymbol) {
        super(elementSymbol);
        this.formalCharge = 0;
    }

    public AtomType(String identifier, String elementSymbol) {
        this(elementSymbol);
        this.identifier = identifier;
    }

    public AtomType(IElement element) {
        super(element);
        if (element instanceof IAtomType) {
            this.maxBondOrder = ((IAtomType)element).getMaxBondOrder();
            this.bondOrderSum = ((IAtomType)element).getBondOrderSum();
            this.covalentRadius = ((IAtomType)element).getCovalentRadius();
            this.formalCharge = ((IAtomType)element).getFormalCharge();
            this.hybridization = ((IAtomType)element).getHybridization();
            this.electronValency = ((IAtomType)element).getValency();
            this.formalNeighbourCount = ((IAtomType)element).getFormalNeighbourCount();
            this.identifier = ((IAtomType)element).getAtomTypeName();
        }
    }

    public void setAtomTypeName(String identifier) {
        this.identifier = identifier;
    }

    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        this.maxBondOrder = maxBondOrder;
    }

    public void setBondOrderSum(Double bondOrderSum) {
        this.bondOrderSum = bondOrderSum;
    }

    public String getAtomTypeName() {
        return this.identifier;
    }

    public IBond.Order getMaxBondOrder() {
        return this.maxBondOrder;
    }

    public Double getBondOrderSum() {
        return this.bondOrderSum;
    }

    public void setFormalCharge(Integer charge) {
        this.formalCharge = charge;
    }

    public Integer getFormalCharge() {
        return this.formalCharge;
    }

    public void setFormalNeighbourCount(Integer count) {
        this.formalNeighbourCount = count;
    }

    public Integer getFormalNeighbourCount() {
        return this.formalNeighbourCount;
    }

    public void setHybridization(IAtomType.Hybridization hybridization) {
        this.hybridization = hybridization;
    }

    public IAtomType.Hybridization getHybridization() {
        return this.hybridization;
    }

    @Override
    public boolean compare(Object object) {
        if (!(object instanceof IAtomType)) {
            return false;
        }
        if (!super.compare(object)) {
            return false;
        }
        AtomType type = (AtomType)object;
        return Objects.equals(this.getAtomTypeName(), type.getAtomTypeName()) && Objects.equals(this.maxBondOrder, type.maxBondOrder) && Objects.equals(this.bondOrderSum, type.bondOrderSum);
    }

    public void setCovalentRadius(Double radius) {
        this.covalentRadius = radius;
    }

    public Double getCovalentRadius() {
        return this.covalentRadius;
    }

    public void setValency(Integer valency) {
        this.electronValency = valency;
    }

    public Integer getValency() {
        return this.electronValency;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toString() {
        StringBuffer resultString = new StringBuffer(64);
        resultString.append("AtomType(").append(this.hashCode());
        if (this.getAtomTypeName() != null) {
            resultString.append(", N:").append(this.getAtomTypeName());
        }
        if (this.getMaxBondOrder() != null) {
            resultString.append(", MBO:").append(this.getMaxBondOrder());
        }
        if (this.getBondOrderSum() != null) {
            resultString.append(", BOS:").append(this.getBondOrderSum());
        }
        if (this.getFormalCharge() != null) {
            resultString.append(", FC:").append(this.getFormalCharge());
        }
        if (this.getHybridization() != null) {
            resultString.append(", H:").append(this.getHybridization());
        }
        if (this.getFormalNeighbourCount() != null) {
            resultString.append(", NC:").append(this.getFormalNeighbourCount());
        }
        if (this.getCovalentRadius() != null) {
            resultString.append(", CR:").append(this.getCovalentRadius());
        }
        if (this.getValency() != null) {
            resultString.append(", EV:").append(this.getValency());
        }
        resultString.append(", ").append(super.toString());
        resultString.append(')');
        return resultString.toString();
    }
}

