/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.elements;

import java.util.ArrayDeque;
import javax.vecmath.Vector2d;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.GeneralPath;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.IRenderingVisitor;
import org.openscience.cdk.renderer.elements.LineElement;
import org.openscience.cdk.renderer.elements.MarkedElement;
import org.openscience.cdk.renderer.elements.OvalElement;
import org.openscience.cdk.renderer.elements.path.PathElement;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class Bounds
implements IRenderingElement {
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;
    private final ElementGroup elements = new ElementGroup();

    public Bounds(double x1, double y1, double x2, double y2) {
        this.minX = x1;
        this.minY = y1;
        this.maxX = x2;
        this.maxY = y2;
    }

    public Bounds() {
        this(Double.MAX_VALUE, Double.MAX_VALUE, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public Bounds(IRenderingElement element) {
        this();
        this.add(element);
    }

    public void add(IRenderingElement element) {
        this.elements.add(element);
        this.traverse(element);
    }

    public void add(double x, double y) {
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
    }

    public void add(Bounds bounds) {
        if (bounds.minX < this.minX) {
            this.minX = bounds.minX;
        }
        if (bounds.minY < this.minY) {
            this.minY = bounds.minY;
        }
        if (bounds.maxX > this.maxX) {
            this.maxX = bounds.maxX;
        }
        if (bounds.maxY > this.maxY) {
            this.maxY = bounds.maxY;
        }
    }

    private void add(GeneralPath path) {
        double[] points = new double[6];
        for (PathElement element : path.elements) {
            element.points(points);
            switch (element.type()) {
                case MoveTo: 
                case LineTo: {
                    this.add(points[0], points[1]);
                    break;
                }
                case QuadTo: {
                    this.add(points[2], points[3]);
                    break;
                }
                case CubicTo: {
                    this.add(points[4], points[5]);
                }
            }
        }
    }

    private void traverse(IRenderingElement newElement) {
        ArrayDeque<IRenderingElement> stack = new ArrayDeque<IRenderingElement>();
        stack.push(newElement);
        while (!stack.isEmpty()) {
            IRenderingElement element = (IRenderingElement)stack.poll();
            if (element instanceof Bounds) {
                this.add((Bounds)element);
                continue;
            }
            if (element instanceof GeneralPath) {
                this.add((GeneralPath)element);
                continue;
            }
            if (element instanceof LineElement) {
                LineElement lineElem = (LineElement)element;
                Vector2d vec = new Vector2d(lineElem.secondPointX - lineElem.firstPointX, lineElem.secondPointY - lineElem.firstPointY);
                Vector2d ortho = new Vector2d(-vec.y, vec.x);
                ortho.normalize();
                vec.normalize();
                ortho.scale(lineElem.width / 2.0);
                vec.scale(lineElem.width / 2.0);
                this.add(lineElem.firstPointX - vec.x + ortho.x, lineElem.firstPointY - vec.y + ortho.y);
                this.add(lineElem.secondPointX + vec.x + ortho.x, lineElem.secondPointY + vec.y + ortho.y);
                this.add(lineElem.firstPointX - vec.x - ortho.x, lineElem.firstPointY - vec.y - ortho.y);
                this.add(lineElem.secondPointX + vec.x - ortho.x, lineElem.secondPointY + vec.y - ortho.y);
                continue;
            }
            if (element instanceof OvalElement) {
                OvalElement oval = (OvalElement)element;
                this.add(oval.xCoord - oval.radius, oval.yCoord);
                this.add(oval.xCoord + oval.radius, oval.yCoord);
                this.add(oval.xCoord, oval.yCoord - oval.radius);
                this.add(oval.xCoord, oval.yCoord + oval.radius);
                continue;
            }
            if (element instanceof ElementGroup) {
                for (IRenderingElement child : (ElementGroup)element) {
                    stack.add(child);
                }
                continue;
            }
            if (element instanceof MarkedElement) {
                stack.add(((MarkedElement)element).element());
                continue;
            }
            LoggingToolFactory.createLoggingTool(Bounds.class).warn((Object)(element.getClass() + " not included in bounds calculation"));
        }
    }

    public IRenderingElement root() {
        return this.elements;
    }

    public final double width() {
        return this.maxX - this.minX;
    }

    public final double height() {
        return this.maxY - this.minY;
    }

    public final boolean isEmpty() {
        return this.minX > this.maxX || this.minY > this.maxY;
    }

    public void accept(IRenderingVisitor visitor) {
        visitor.visit((IRenderingElement)this);
    }

    public String toString() {
        return "{{" + this.minX + ", " + this.minY + "} - {" + this.maxX + ", " + this.maxY + "}}";
    }
}

