/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.AtomRef;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryChemObject;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class QueryAtom
extends QueryChemObject
implements IQueryAtom {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(QueryAtom.class);
    protected Double charge = (Double)CDKConstants.UNSET;
    protected Point2d point2d = (Point2d)CDKConstants.UNSET;
    protected Point3d point3d = (Point3d)CDKConstants.UNSET;
    protected Point3d fractionalPoint3d = (Point3d)CDKConstants.UNSET;
    protected Integer hydrogenCount = (Integer)CDKConstants.UNSET;
    protected Integer stereoParity = (Integer)CDKConstants.UNSET;
    IBond.Order maxBondOrder = null;
    Double bondOrderSum = (Double)CDKConstants.UNSET;
    Double covalentRadius = (Double)CDKConstants.UNSET;
    protected Integer formalCharge = (Integer)CDKConstants.UNSET;
    protected IAtomType.Hybridization hybridization = (IAtomType.Hybridization)CDKConstants.UNSET;
    protected Integer electronValency = (Integer)CDKConstants.UNSET;
    protected Integer formalNeighbourCount = (Integer)CDKConstants.UNSET;
    private String identifier = (String)CDKConstants.UNSET;
    public Double exactMass;
    public Double naturalAbundance;
    private Integer massNumber;
    protected String symbol;
    protected Integer atomicNumber = (Integer)CDKConstants.UNSET;
    private Expr expr = new Expr(Expr.Type.TRUE);

    public QueryAtom(String symbol, IChemObjectBuilder builder) {
        this(builder);
        this.symbol = symbol;
        this.atomicNumber = PeriodicTable.getAtomicNumber((String)symbol);
    }

    public QueryAtom(IChemObjectBuilder builder) {
        super(builder);
    }

    public int getIndex() {
        return -1;
    }

    public IAtomContainer getContainer() {
        return null;
    }

    public Iterable<IBond> bonds() {
        throw new UnsupportedOperationException();
    }

    public int getBondCount() {
        throw new UnsupportedOperationException();
    }

    public IBond getBond(IAtom atom) {
        throw new UnsupportedOperationException();
    }

    public void setCharge(Double charge) {
        this.charge = charge;
        this.notifyChanged();
    }

    public Double getCharge() {
        return this.charge;
    }

    public void setImplicitHydrogenCount(Integer hydrogenCount) {
        this.hydrogenCount = hydrogenCount;
        this.notifyChanged();
    }

    public Integer getImplicitHydrogenCount() {
        return this.hydrogenCount;
    }

    public void setPoint2d(Point2d point2d) {
        this.point2d = point2d;
        this.notifyChanged();
    }

    public void setPoint3d(Point3d point3d) {
        this.point3d = point3d;
        this.notifyChanged();
    }

    public void setFractionalPoint3d(Point3d point3d) {
        this.fractionalPoint3d = point3d;
        this.notifyChanged();
    }

    public void setStereoParity(Integer stereoParity) {
        this.stereoParity = stereoParity;
        this.notifyChanged();
    }

    public Point2d getPoint2d() {
        return this.point2d;
    }

    public Point3d getPoint3d() {
        return this.point3d;
    }

    public Point3d getFractionalPoint3d() {
        return this.fractionalPoint3d;
    }

    public Integer getStereoParity() {
        return this.stereoParity;
    }

    public void setAtomTypeName(String identifier) {
        this.identifier = identifier;
        this.notifyChanged();
    }

    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        this.maxBondOrder = maxBondOrder;
        this.notifyChanged();
    }

    public void setBondOrderSum(Double bondOrderSum) {
        this.bondOrderSum = bondOrderSum;
        this.notifyChanged();
    }

    public String getAtomTypeName() {
        return this.identifier;
    }

    public IBond.Order getMaxBondOrder() {
        return this.maxBondOrder;
    }

    public Double getBondOrderSum() {
        return this.bondOrderSum;
    }

    public void setFormalCharge(Integer charge) {
        this.formalCharge = charge;
        this.notifyChanged();
    }

    public Integer getFormalCharge() {
        return this.formalCharge;
    }

    public void setFormalNeighbourCount(Integer count) {
        this.formalNeighbourCount = count;
        this.notifyChanged();
    }

    public Integer getFormalNeighbourCount() {
        return this.formalNeighbourCount;
    }

    public void setHybridization(IAtomType.Hybridization hybridization) {
        this.hybridization = hybridization;
        this.notifyChanged();
    }

    public IAtomType.Hybridization getHybridization() {
        return this.hybridization;
    }

    public void setNaturalAbundance(Double naturalAbundance) {
        this.naturalAbundance = naturalAbundance;
        this.notifyChanged();
    }

    public void setExactMass(Double exactMass) {
        this.exactMass = exactMass;
        this.notifyChanged();
    }

    public Double getNaturalAbundance() {
        return this.naturalAbundance;
    }

    public Double getExactMass() {
        return this.exactMass;
    }

    public Integer getMassNumber() {
        return this.massNumber;
    }

    public void setMassNumber(Integer massNumber) {
        this.massNumber = massNumber;
        this.notifyChanged();
    }

    public Integer getAtomicNumber() {
        return this.atomicNumber;
    }

    public void setAtomicNumber(Integer atomicNumber) {
        this.atomicNumber = atomicNumber;
        this.notifyChanged();
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
        this.notifyChanged();
    }

    public void setCovalentRadius(Double radius) {
        this.covalentRadius = radius;
        this.notifyChanged();
    }

    public Double getCovalentRadius() {
        return this.covalentRadius;
    }

    public void setValency(Integer valency) {
        this.electronValency = valency;
        this.notifyChanged();
    }

    public Integer getValency() {
        return this.electronValency;
    }

    public boolean isAromatic() {
        return this.getFlag(32);
    }

    public void setIsAromatic(boolean arom) {
        this.setFlag(32, arom);
    }

    public boolean isInRing() {
        return this.getFlag(2);
    }

    public void setIsInRing(boolean ring) {
        this.setFlag(2, ring);
    }

    public void setExpression(Expr expr) {
        this.expr = expr;
    }

    public Expr getExpression() {
        return this.expr;
    }

    @Override
    public boolean matches(IAtom atom) {
        return this.expr.matches(atom);
    }

    public IAtom clone() throws CloneNotSupportedException {
        return (IAtom)super.clone();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AtomRef) {
            return super.equals(((AtomRef)obj).deref());
        }
        return super.equals(obj);
    }

    public QueryAtom(Expr expr) {
        this((IChemObjectBuilder)null);
        this.expr.set(expr);
    }

    public QueryAtom(Expr.Type type) {
        this(new Expr(type));
    }

    public QueryAtom(Expr.Type type, int val) {
        this(new Expr(type, val));
    }
}

